/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.app;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.Parameters;
import openwfe.org.ReflectionUtils;
import openwfe.org.Service;
import openwfe.org.Utils;
import openwfe.org.app.ApplicationBuildingException;
import openwfe.org.app.ApplicationContextBuilder;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class XmlApplicationContextBuilder
implements ApplicationContextBuilder {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$app$XmlApplicationContextBuilder == null ? (class$openwfe$org$app$XmlApplicationContextBuilder = XmlApplicationContextBuilder.class$("openwfe.org.app.XmlApplicationContextBuilder")) : class$openwfe$org$app$XmlApplicationContextBuilder).getName());
    static /* synthetic */ Class class$openwfe$org$app$XmlApplicationContextBuilder;

    public ApplicationContext build(Object info) throws ApplicationBuildingException {
        return this.build(info, null);
    }

    public ApplicationContext build(Object info, String applicationDirectory) throws ApplicationBuildingException {
        if (info == null) {
            throw new ApplicationBuildingException("Cannot build ApplicationContext out of 'null' info.");
        }
        ApplicationContext result = null;
        if (info instanceof String) {
            String s = (String)info;
            try {
                return this.build(new URL(Utils.expandUrl(s)), applicationDirectory);
            }
            catch (MalformedURLException mue) {
                throw new ApplicationBuildingException("Cannot build ApplicationContext out of URL '" + info + "'");
            }
        }
        if (info instanceof URL) {
            return this.doBuild((URL)info, applicationDirectory);
        }
        if (result == null) {
            throw new ApplicationBuildingException("Cannot build ApplicationContext out of instance of class " + info.getClass());
        }
        return result;
    }

    private ApplicationContext doBuild(URL url, String applicationDirectory) throws ApplicationBuildingException {
        log.info((Object)("doBuild(u) building from '" + url + "'"));
        Document xmlConfiguration = null;
        try {
            SAXBuilder builder = new SAXBuilder();
            xmlConfiguration = builder.build(url);
        }
        catch (Throwable t) {
            throw new ApplicationBuildingException("Failed to interpret configuration file '" + url + "'", t);
        }
        long lastModified = -1L;
        try {
            URLConnection con = url.openConnection();
            lastModified = con.getLastModified();
        }
        catch (Throwable t) {
            log.info((Object)("doBuild() couldn't determine lastModified time for configuration file at " + url));
        }
        return this.doBuild(lastModified, xmlConfiguration.getRootElement(), applicationDirectory);
    }

    private ApplicationContext doBuild(long lastModified, Element element, String applicationDirectory) throws ApplicationBuildingException {
        ApplicationContext result = new ApplicationContext();
        result.setLastModified(lastModified);
        String name = element.getAttributeValue("name");
        if (name != null) {
            name = name.trim();
            result.setApplicationName(name);
            ApplicationContext.contextMap.put(name, result);
            log.info((Object)("doBuild() put '" + name + "' in contextMap"));
        }
        Iterator it = element.getChildren("include").iterator();
        while (it.hasNext()) {
            Element eInclude = (Element)it.next();
            String configFileName = eInclude.getAttributeValue("configuration");
            ApplicationContext child = this.build(configFileName);
            child.setParentContext(result);
            result.put(child.getApplicationName(), child);
            log.info((Object)("Added sub-application under '" + child.getApplicationName() + "'"));
        }
        Map globalParams = Parameters.extractParameters(element);
        result.putAll(globalParams);
        if (applicationDirectory != null) {
            result.setApplicationDirectory(applicationDirectory);
        }
        this.bindSystemProperties(element);
        List services = element.getChildren("service");
        it = services.iterator();
        while (it.hasNext()) {
            Element elt = (Element)it.next();
            String serviceName = elt.getAttributeValue("name");
            String serviceClassName = elt.getAttributeValue("class");
            Map serviceParams = Parameters.extractParameters(elt);
            Service service = null;
            try {
                Class<?> serviceClass = Class.forName(serviceClassName);
                service = (Service)serviceClass.newInstance();
                service.init(serviceName, result, serviceParams);
            }
            catch (Throwable t) {
                log.info((Object)("Failed to instantiate service '" + serviceName + "'"), t);
                continue;
            }
            result.put(serviceName, service);
            log.info((Object)("bound service '" + serviceName + "' (" + serviceClassName + ")"));
        }
        log.info((Object)("Application '" + name + "' has been launched\n\n"));
        return result;
    }

    protected void bindSystemProperties(Element elt) {
        Iterator it = elt.getChildren("property").iterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            this.bindSystemProperty(e);
        }
    }

    protected void bindSystemProperty(Element elt) {
        String name = elt.getAttributeValue("name");
        String value = elt.getAttributeValue("value");
        String constant = elt.getAttributeValue("constant");
        if (name == null) {
            name = elt.getChildTextTrim("name");
            value = elt.getChildTextTrim("value");
            constant = elt.getChildTextTrim("constant");
        }
        if (name == null) {
            name = elt.getChildTextTrim("property-name");
            value = elt.getChildTextTrim("property-value");
            constant = elt.getChildTextTrim("property-constant");
        }
        if (name == null) {
            log.warn((Object)"bindSystemProperty() <property/> without a 'name' attribute. Skipped.");
            return;
        }
        if (constant != null) {
            value = ReflectionUtils.lookupConstantValue(constant);
        }
        name = name.trim();
        value = value.trim();
        System.getProperties().put(name, value);
        log.info((Object)("bindSystemProperty() '" + name + "' --> '" + value + "'"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

