/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.auth.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.Parameters;
import openwfe.org.ReflectionUtils;
import openwfe.org.auth.AuthException;
import openwfe.org.auth.Principal;
import openwfe.org.auth.PrincipalCodec;
import org.jdom.Content;
import org.jdom.Element;

public class XmlPrincipalCodec
implements PrincipalCodec {
    public static final String E_PRINCIPAL = "principal";
    public static final String A_CLASS = "class";
    public static final String A_NAME = "name";
    public static final String E_GRANT = "grant";

    public Object encodePrincipal(Principal p, ApplicationContext context, Map serviceParams) throws AuthException {
        Element ePrincipal = new Element(E_PRINCIPAL);
        HashMap<String, String> params = new HashMap<String, String>();
        if (p.getInitParameters() != null) {
            params.putAll(p.getInitParameters());
        }
        params.put(A_CLASS, p.getClass().getName());
        Parameters.encodeAsAttributes(ePrincipal, params);
        Iterator it = p.getGrants().iterator();
        while (it.hasNext()) {
            String grantName = (String)it.next();
            Element eGrant = new Element(E_GRANT);
            eGrant.setAttribute(A_NAME, grantName);
            ePrincipal.addContent((Content)eGrant);
        }
        return ePrincipal;
    }

    public Principal decodePrincipal(ApplicationContext context, Object o) throws AuthException {
        Element elt = null;
        try {
            elt = (Element)o;
        }
        catch (ClassCastException cce) {
            throw new AuthException("Cannot decode Principal from class " + o.getClass(), cce);
        }
        if (elt == null || !elt.getName().equals(E_PRINCIPAL)) {
            throw new AuthException("null XML element or not a <principal>");
        }
        Principal principal = null;
        Map params = Parameters.extractAttributes(elt);
        String className = (String)params.get(A_CLASS);
        try {
            principal = (Principal)ReflectionUtils.initObjectOfClass(className, params);
        }
        catch (Exception e) {
            throw new AuthException("failed to build Principal of class " + className, e);
        }
        Iterator it = elt.getChildren(E_GRANT).iterator();
        while (it.hasNext()) {
            Element eGrant = (Element)it.next();
            principal.addGrant(eGrant.getAttributeValue(A_NAME));
        }
        return principal;
    }
}

