/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.sql.ds;

import java.util.Map;
import javax.sql.DataSource;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.sql.ds.OwfeDataSource;
import org.apache.log4j.Logger;
import org.postgresql.jdbc3.Jdbc3SimpleDataSource;

public class PostgresDataSource
extends OwfeDataSource {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$sql$ds$PostgresDataSource == null ? (class$openwfe$org$sql$ds$PostgresDataSource = PostgresDataSource.class$("openwfe.org.sql.ds.PostgresDataSource")) : class$openwfe$org$sql$ds$PostgresDataSource).getName());
    public static final String P_USER = "user";
    public static final String P_PASS = "pass";
    private static final String CON_VALIDITY_SQL_CODE = "SELECT 1";
    static /* synthetic */ Class class$openwfe$org$sql$ds$PostgresDataSource;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        String url = MapUtils.getMandatoryString(this.getParams(), "url");
        String user = MapUtils.getMandatoryString(this.getParams(), P_USER);
        String pass = MapUtils.getMandatoryString(this.getParams(), P_PASS);
        Jdbc3SimpleDataSource ds = new Jdbc3SimpleDataSource();
        this.setUpDataSource(ds, url, user, pass);
        this.setDataSource((DataSource)ds);
    }

    protected void setUpDataSource(Jdbc3SimpleDataSource source, String url, String user, String pass) throws ServiceException {
        source.setUser(user);
        source.setPassword(pass);
        if (!url.startsWith("jdbc:postgresql:")) {
            throw new ServiceException("url '" + url + "' should begin with 'jdbc:postgresql:'");
        }
        if (!(url = url.substring(16)).startsWith("//")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("setUpDataSource() DatabaseName >" + url + "<"));
            }
            source.setDatabaseName(url);
            return;
        }
        url = url.substring(2);
        String[] ss = url.split("/");
        String hostAndPort = ss[0];
        String databaseName = ss[1];
        if (log.isDebugEnabled()) {
            log.debug((Object)("setUpDataSource() DatabaseName >" + databaseName + "<"));
        }
        source.setDatabaseName(databaseName);
        if (hostAndPort.indexOf(":") > -1) {
            ss = hostAndPort.split(":");
            if (log.isDebugEnabled()) {
                log.debug((Object)("setUpDataSource() ServerName >" + ss[0] + "<"));
            }
            source.setServerName(ss[0]);
            int port = -1;
            try {
                port = Integer.parseInt(ss[1]);
            }
            catch (NumberFormatException nfe) {
                throw new ServiceException("invalid port number '" + ss[1] + "'", nfe);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("setUpDataSource() PortNumber >" + port + "<"));
            }
            source.setPortNumber(port);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("setUpDataSource() ServerName >" + hostAndPort + "<"));
            }
            source.setServerName(hostAndPort);
        }
    }

    public String getConnectionValiditySqlCode() {
        return CON_VALIDITY_SQL_CODE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

