/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.xconf;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import openwfe.org.ServiceException;
import openwfe.org.Utils;
import openwfe.org.xconf.XconfElementBuilder;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class XconfBuilder {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$xconf$XconfBuilder == null ? (class$openwfe$org$xconf$XconfBuilder = XconfBuilder.class$("openwfe.org.xconf.XconfBuilder")) : class$openwfe$org$xconf$XconfBuilder).getName());
    private XconfElementBuilder eltBuilder = null;
    private URL sourceUrl = null;
    private long sourceLastModified = 0L;
    static /* synthetic */ Class class$openwfe$org$xconf$XconfBuilder;

    public XconfBuilder(String configurationFileUrl, XconfElementBuilder eltBuilder) throws ServiceException {
        this.eltBuilder = eltBuilder;
        if (log.isDebugEnabled()) {
            log.debug((Object)("XconfBuilder() considering url " + configurationFileUrl));
        }
        if (configurationFileUrl.startsWith("resource:")) {
            this.sourceUrl = this.getClass().getResource(configurationFileUrl.substring(9));
        } else {
            try {
                this.sourceUrl = new URL(configurationFileUrl);
            }
            catch (MalformedURLException mue) {
                throw new ServiceException("Could not build URL out of '" + configurationFileUrl + "'", mue);
            }
        }
    }

    public URL getSourceUrl() {
        return this.sourceUrl;
    }

    public void buildConfig() throws ServiceException {
        this.eltBuilder.clearConfig();
        this.buildConfig(this.sourceUrl);
        this.sourceLastModified = this.sourceLastModified();
    }

    private void buildConfig(URL mapUrl) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("buildConfig(u) building " + mapUrl));
        }
        this.eltBuilder.clearConfig();
        Element rootElement = null;
        try {
            rootElement = XmlUtils.extractXml(mapUrl, false);
        }
        catch (Throwable t) {
            throw new ServiceException("Failed to build configuration out of '" + mapUrl + "'", t);
        }
        Iterator it = rootElement.getChildren().iterator();
        while (it.hasNext()) {
            Element elt = (Element)it.next();
            if (elt.getName().equals("include")) {
                String sIncludeUrl = elt.getAttributeValue("url");
                try {
                    this.buildConfig(new URL(sIncludeUrl));
                }
                catch (Throwable t) {
                    log.warn((Object)("buildConfig(u) cannot build include " + sIncludeUrl + ". Skipped"), t);
                }
                continue;
            }
            this.eltBuilder.parseElement(this, elt);
        }
    }

    private long sourceLastModified() {
        if (this.sourceUrl == null) {
            return -1L;
        }
        long fileLastModified = Utils.getLastModified(this.sourceUrl);
        if (log.isDebugEnabled()) {
            log.debug((Object)("newLastModified() this.sourceLastModified = " + this.sourceLastModified));
            log.debug((Object)("newLastModified() fileLastModified        = " + fileLastModified));
        }
        if (this.sourceLastModified < fileLastModified) {
            return fileLastModified;
        }
        return -1L;
    }

    public boolean hasSourceBeenModified() {
        return this.sourceLastModified() > -1L;
    }

    public void refreshConfig() throws ServiceException {
        if (this.hasSourceBeenModified()) {
            log.info((Object)("refreshConfig() config file " + this.sourceUrl + " modified => reparsing"));
            this.buildConfig();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

