/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import openwfe.org.time.Time;
import org.apache.log4j.Logger;

public abstract class MapUtils {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$MapUtils == null ? (class$openwfe$org$MapUtils = MapUtils.class$("openwfe.org.MapUtils")) : class$openwfe$org$MapUtils).getName());
    static /* synthetic */ Class class$openwfe$org$MapUtils;

    private MapUtils() {
    }

    public static String getAsString(Map m, String key) {
        Object value = m.get(key);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static String getAsString(Map m, String key, String defaultValue) {
        String value = MapUtils.getAsString(m, key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static String getMandatoryString(Map m, String key) {
        String result = MapUtils.getAsString(m, key);
        if (result == null) {
            throw new IllegalArgumentException("mandatory parameter '" + key + "' is missing.");
        }
        return result;
    }

    public static int getMandatoryInt(Map m, String key) {
        String sValue = MapUtils.getAsString(m, key);
        if (sValue == null) {
            throw new IllegalArgumentException("mandatory int parameter '" + key + "' is missing.");
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("mandatory int parameter '" + key + "' has value '" + sValue + "' which cannot be mapped to an integer");
        }
    }

    public static Object[] getMandatoryTimeAndString(Map m, String key) {
        String sValue = MapUtils.getMandatoryString(m, key);
        try {
            long tValue = Time.parseTimeString(sValue);
            return new Object[]{new Long(tValue), sValue};
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to turn '" + sValue + "' into a count of milliseconds.");
        }
    }

    public static long getAsTime(Map m, String key) throws NumberFormatException {
        String sValue = MapUtils.getAsString(m, key);
        if (sValue == null) {
            throw new NumberFormatException("No assigned value for '" + key + "'");
        }
        return Time.parseTimeString(sValue);
    }

    public static long getAsTime(Map m, String key, long defaultValue) throws NumberFormatException {
        String sValue = MapUtils.getAsString(m, key);
        if (sValue == null) {
            return defaultValue;
        }
        return Time.parseTimeString(sValue);
    }

    public static long getAsTime(Map m, String key, String defaultValue) throws NumberFormatException {
        String sValue = MapUtils.getAsString(m, key);
        if (sValue == null) {
            return Time.parseTimeString(defaultValue);
        }
        return Time.parseTimeString(sValue);
    }

    public static long getAsLong(Map m, String key) throws NumberFormatException {
        String sValue = MapUtils.getAsString(m, key);
        if (sValue == null) {
            throw new NumberFormatException("No assigned value for '" + key + "'");
        }
        return Long.parseLong(sValue);
    }

    public static long getAsLong(Map m, String key, long defaultValue) {
        String sValue = MapUtils.getAsString(m, key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(sValue);
        }
        catch (NumberFormatException nfe) {
            log.info((Object)("'" + sValue + "' isn't a long value. Returning default " + defaultValue));
            return defaultValue;
        }
    }

    public static int getAsInt(Map m, String key, int defaultValue) {
        String sValue = MapUtils.getAsString(m, key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException nfe) {
            log.info((Object)("'" + sValue + "' isn't an int value. Returning default " + defaultValue));
            return defaultValue;
        }
    }

    public static boolean getAsBoolean(Map m, String key, boolean defaultValue) {
        Object o = m.get(key);
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        String sValue = o.toString();
        return sValue.equalsIgnoreCase("true");
    }

    public static double getAsDouble(Map m, String key) throws NumberFormatException {
        String sValue = MapUtils.getAsString(m, key);
        if (sValue == null) {
            throw new NumberFormatException("No assigned value for '" + key + "'");
        }
        return Double.parseDouble(sValue);
    }

    public static float getAsFloat(Map m, String paramName, float defaultValue) {
        try {
            return Float.parseFloat(MapUtils.getAsString(m, paramName));
        }
        catch (Throwable throwable) {
            return defaultValue;
        }
    }

    public static List getAsList(Map m, String paramName) {
        String s = (String)m.get(paramName);
        if (s == null) {
            return null;
        }
        s = s.trim();
        String[] ss = s.split(",\\s*");
        ArrayList<String> l = new ArrayList<String>(ss.length);
        for (int i = 0; i < ss.length; ++i) {
            l.add(ss[i].trim());
        }
        return l;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

