/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;

public abstract class Parameters {
    public static Map extractParameters(Element elt) {
        return Parameters.extractParameters(elt.getChildren("param"));
    }

    public static Map extractParameters(List elements) {
        HashMap<String, String> result = new HashMap<String, String>();
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            Element param = (Element)it.next();
            if (!param.getName().equals("param")) continue;
            String paramName = param.getAttributeValue("name");
            Object paramValue = param.getAttributeValue("value");
            if (paramName == null) {
                paramName = param.getChildTextTrim("param-name");
                paramValue = param.getChildTextTrim("param-value");
            }
            paramName = paramName.trim();
            paramValue = ((String)paramValue).trim();
            Object currentValue = result.get(paramName);
            if (currentValue != null) {
                if (currentValue instanceof String) {
                    String s = (String)currentValue;
                    currentValue = new ArrayList(10);
                    ((List)currentValue).add(s);
                }
                List valueList = (List)currentValue;
                valueList.add(paramValue);
                paramValue = valueList;
            }
            result.put(paramName, (String)paramValue);
        }
        return Collections.unmodifiableMap(result);
    }

    public static Map extractAttributes(Element e) {
        HashMap<String, String> result = new HashMap<String, String>(e.getAttributes().size());
        Iterator it = e.getAttributes().iterator();
        while (it.hasNext()) {
            Attribute a = (Attribute)it.next();
            String key = a.getName();
            String value = a.getValue();
            result.put(key, value);
        }
        return result;
    }

    public static Map extractParamsAndAttributes(Element e) {
        Map result = Parameters.extractAttributes(e);
        result.putAll(Parameters.extractParameters(e));
        return result;
    }

    public static void encodeAsAttributes(Element e, Map params) {
        Iterator it = params.keySet().iterator();
        while (it.hasNext()) {
            Object oKey = it.next();
            String key = oKey.toString();
            String value = params.get(oKey).toString();
            e.setAttribute(key, value);
        }
    }
}

