/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.auth;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import openwfe.org.auth.AuthException;
import openwfe.org.auth.LoginModule;
import openwfe.org.misc.ByteUtils;
import org.apache.log4j.Logger;

public class BasicLoginModule
extends LoginModule {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$auth$BasicLoginModule == null ? (class$openwfe$org$auth$BasicLoginModule = BasicLoginModule.class$("openwfe.org.auth.BasicLoginModule")) : class$openwfe$org$auth$BasicLoginModule).getName());
    public static final String DIGEST_ALGORITHM = "MD5";
    static /* synthetic */ Class class$openwfe$org$auth$BasicLoginModule;

    public static String digestPassword(String pass) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(DIGEST_ALGORITHM);
        digest.update(pass.getBytes());
        return ByteUtils.toString(digest.digest());
    }

    public boolean login() throws LoginException {
        if (this.policyService == null) {
            throw new LoginException("No policy service. Check application log for details");
        }
        NameCallback nameCb = new NameCallback("username");
        PasswordCallback passCb = new PasswordCallback("password", false);
        try {
            this.handler.handle(new Callback[]{nameCb, passCb});
        }
        catch (Exception e) {
            log.debug((Object)"Failed to gather user credentials", (Throwable)e);
            throw new LoginException("Failed to gather user credentials");
        }
        String userName = nameCb.getName();
        String pass = new String(passCb.getPassword());
        try {
            pass = BasicLoginModule.digestPassword(pass);
        }
        catch (NoSuchAlgorithmException nsae) {
            log.warn((Object)"hash algo not found", (Throwable)nsae);
            throw new LoginException("" + nsae);
        }
        this.principal = null;
        try {
            this.principal = this.policyService.authentify(userName, pass);
        }
        catch (AuthException ae) {
            log.info((Object)"LoginException : Failed to authentify user", (Throwable)ae);
            throw new LoginException("Failed to authentify user because of \"" + ae + "\"");
        }
        this.succeeded = this.principal != null;
        return this.succeeded;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println();
            System.out.println("USAGE :");
            System.out.println();
            System.out.println("genpass password");
            System.out.println();
            System.out.print("will output the password, but hashed.");
            System.out.println();
            System.exit(0);
        }
        try {
            System.out.println(BasicLoginModule.digestPassword(args[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

