/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.crypto;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import openwfe.org.crypto.CryptoException;
import org.jdom.Content;
import org.jdom.Element;

public class RsaKey
implements Serializable {
    static final long serialVersionUID = -2578029002953409978L;
    public static final String PUBLIC = "public";
    public static final String PRIVATE = "private";
    public static final String PUBLIC_KEY = "public-key";
    public static final String PRIVATE_KEY = "private-key";
    public static final String EXP = "exp";
    public static final String MOD = "mod";
    protected String keyType = null;
    protected String exp = null;
    protected String mod = null;

    public RsaKey() {
    }

    public RsaKey(String keyType, String exp, String mod) {
        this.keyType = keyType;
        this.exp = exp;
        this.mod = mod;
    }

    public RsaKey(RSAKey key) throws CryptoException {
        this.mod = key.getModulus().toString();
        if (key instanceof RSAPublicKey) {
            this.keyType = PUBLIC;
            this.exp = ((RSAPublicKey)key).getPublicExponent().toString();
        } else if (key instanceof RSAPrivateKey) {
            this.keyType = PRIVATE;
            this.exp = ((RSAPrivateKey)key).getPrivateExponent().toString();
        } else {
            throw new CryptoException("Cannot create RsaKey from key of class '" + key.getClass().getName() + "'");
        }
    }

    public String getKeyType() {
        return this.keyType;
    }

    public String getMod() {
        return this.mod;
    }

    public String getExp() {
        return this.exp;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public void setMod(String s) {
        this.mod = s;
    }

    public void setExp(String s) {
        this.exp = s;
    }

    public RSAKey assembleRealKey() throws CryptoException {
        try {
            KeyFactory factory = KeyFactory.getInstance("RSA");
            if (this.keyType.equals(PUBLIC)) {
                RSAPublicKeySpec spec = new RSAPublicKeySpec(new BigInteger(this.mod), new BigInteger(this.exp));
                return (RSAKey)((Object)factory.generatePublic(spec));
            }
            RSAPrivateKeySpec spec = new RSAPrivateKeySpec(new BigInteger(this.mod), new BigInteger(this.exp));
            return (RSAKey)((Object)factory.generatePrivate(spec));
        }
        catch (Exception e) {
            throw new CryptoException("Failed to assemble real RSAKey", e);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.keyType.equals(PUBLIC)) {
            sb.append("<public-key>\n");
        } else {
            sb.append("<private-key>\n");
        }
        sb.append("    <exp>");
        sb.append(this.exp);
        sb.append("</exp>\n");
        sb.append("    <mod>");
        sb.append(this.mod);
        sb.append("</mod>\n");
        if (this.keyType.equals(PUBLIC)) {
            sb.append("</public-key>\n");
        } else {
            sb.append("</private-key>\n");
        }
        return sb.toString();
    }

    public Element toXml() {
        Element eKey = null;
        eKey = this.keyType.equals(PUBLIC) ? new Element(PUBLIC_KEY) : new Element(PRIVATE_KEY);
        Element eExp = new Element(EXP);
        eExp.addContent(this.exp);
        eKey.addContent((Content)eExp);
        Element eMod = new Element(MOD);
        eMod.addContent(this.mod);
        eKey.addContent((Content)eMod);
        return eKey;
    }

    public static RsaKey buildKey(Element elt) {
        if (elt == null) {
            return null;
        }
        String eName = elt.getName();
        String keyType = PRIVATE;
        if (eName.equals(PUBLIC_KEY)) {
            keyType = PUBLIC;
        }
        String exp = elt.getChildTextTrim(EXP);
        String mod = elt.getChildTextTrim(MOD);
        return new RsaKey(keyType, exp, mod);
    }

    public static RsaKey[] generateKeyPair(int strength) throws CryptoException {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(strength);
            KeyPair pair = generator.generateKeyPair();
            RsaKey[] result = new RsaKey[]{new RsaKey((RSAKey)((Object)pair.getPublic())), new RsaKey((RSAKey)((Object)pair.getPrivate()))};
            return result;
        }
        catch (Exception e) {
            throw new CryptoException("Failed to generate key pair", e);
        }
    }

    public static void main(String[] args) {
        try {
            System.out.println("Generating key pair...");
            RsaKey[] keyPair = RsaKey.generateKeyPair(2048);
            System.out.println(keyPair[0].toString());
            System.out.println(keyPair[1].toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

