/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.ldap;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import openwfe.org.AbstractService;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import org.apache.log4j.Logger;

public class LdapService
extends AbstractService {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$ldap$LdapService == null ? (class$openwfe$org$ldap$LdapService = LdapService.class$("openwfe.org.ldap.LdapService")) : class$openwfe$org$ldap$LdapService).getName());
    public static final String P_HOST = "host";
    public static final String P_PORT = "port";
    public static final String P_AUTH_METHOD = "authentication-method";
    public static final String P_INITIAL_CONTEXT_FACTORY = "initial-context-factory";
    public static final String P_USER_BASE = "user-base";
    public static final String P_USER_ATTRIBUTE = "user-attribute";
    public static final String P_USER_OBJCLASS = "user-objclass";
    public static final String P_GROUP_BASE = "group-base";
    public static final String P_GROUP_ATTRIBUTE = "group-attribute";
    public static final String P_GROUP_OBJCLASS = "group-objclass";
    public static final String P_TRUNCATE_SUFFIX = "truncate-suffix";
    private Properties m_envProps;
    private String m_host;
    private String m_port;
    private String m_authenticationMethod;
    private String m_userBase;
    private String m_userAttr;
    private String m_userObjClass;
    private String m_groupBase;
    private String m_groupAttr;
    private String m_groupObjClass;
    private String m_truncateSuffix;
    private InitialDirContext m_dirCtx;
    static /* synthetic */ Class class$openwfe$org$ldap$LdapService;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        log.info((Object)"LdapService init()");
        super.init(serviceName, context, serviceParams);
        this.m_host = (String)serviceParams.get(P_HOST);
        this.m_port = (String)serviceParams.get(P_PORT);
        this.m_authenticationMethod = (String)serviceParams.get(P_AUTH_METHOD);
        this.m_envProps = new Properties();
        this.m_envProps.put("java.naming.factory.initial", MapUtils.getAsString(serviceParams, P_INITIAL_CONTEXT_FACTORY, "com.sun.jndi.ldap.LdapCtxFactory"));
        this.m_envProps.put("java.naming.provider.url", "ldap://" + this.m_host + ":" + this.m_port);
        this.m_envProps.put("java.naming.security.authentication", this.m_authenticationMethod);
        this.m_userBase = (String)serviceParams.get(P_USER_BASE);
        this.m_userAttr = (String)serviceParams.get(P_USER_ATTRIBUTE);
        this.m_userObjClass = (String)serviceParams.get(P_USER_OBJCLASS);
        this.m_groupBase = (String)serviceParams.get(P_GROUP_BASE);
        this.m_groupAttr = (String)serviceParams.get(P_GROUP_ATTRIBUTE);
        this.m_groupObjClass = (String)serviceParams.get(P_GROUP_OBJCLASS);
        this.m_truncateSuffix = (String)serviceParams.get(P_TRUNCATE_SUFFIX);
        if (log.isInfoEnabled()) {
            log.info((Object)("Using " + this.m_host + ":" + this.m_port + " for ldap."));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("User base: " + this.m_userBase));
            log.debug((Object)("User attr: " + this.m_userAttr));
            log.debug((Object)("User objclass: " + this.m_userObjClass));
            log.debug((Object)("Group base: " + this.m_groupBase));
            log.debug((Object)("Group attr: " + this.m_groupAttr));
            log.debug((Object)("Group objclass: " + this.m_groupObjClass));
            log.debug((Object)("Strip suffix: " + this.m_truncateSuffix));
        }
        try {
            this.m_dirCtx = new InitialDirContext(this.m_envProps);
        }
        catch (NamingException e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    private String stripSuffix(String dn) {
        if (this.m_truncateSuffix == null) {
            return dn;
        }
        if (dn.endsWith(this.m_truncateSuffix)) {
            return dn.substring(0, dn.length() - this.m_truncateSuffix.length());
        }
        return dn;
    }

    public String getLdapUid(Principal p) {
        return this.stripSuffix(this.m_userAttr + "=" + p.getName() + "," + this.m_userBase);
    }

    public String[] getGroups(Principal p) throws NamingException {
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(1);
        String id = this.getLdapUid(p);
        int i = id.indexOf(",");
        if (i != -1) {
            id = id.substring(0, i);
        }
        if ((i = id.indexOf("=")) != -1) {
            id = id.substring(i + 1);
        }
        NamingEnumeration<SearchResult> results = this.m_dirCtx.search(this.m_groupBase, "memberUid=" + id, constraints);
        ArrayList<String> groups = new ArrayList<String>();
        while (results != null && results.hasMoreElements()) {
            SearchResult si = results.next();
            groups.add(this.stripSuffix(si.getName() + "," + this.m_groupBase));
        }
        return groups.toArray(new String[0]);
    }

    public String[] getGroups() throws NamingException {
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(1);
        NamingEnumeration<SearchResult> results = this.m_groupObjClass != null && !"".equals(this.m_groupObjClass) ? this.m_dirCtx.search(this.m_groupBase, "(&(objectClass=" + this.m_groupObjClass + ")(" + this.m_groupAttr + "=*))", constraints) : this.m_dirCtx.search(this.m_groupBase, this.m_groupAttr + "=*", constraints);
        ArrayList<String> groups = new ArrayList<String>();
        while (results != null && results.hasMoreElements()) {
            SearchResult si = results.next();
            groups.add(this.stripSuffix(si.getName() + "," + this.m_groupBase));
        }
        return groups.toArray(new String[0]);
    }

    public String[] getUsers() throws NamingException {
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(1);
        NamingEnumeration<SearchResult> results = this.m_userObjClass != null && !"".equals(this.m_userObjClass) ? this.m_dirCtx.search(this.m_userBase, "(&(objectClass=" + this.m_userObjClass + ")(" + this.m_userAttr + "=*))", constraints) : this.m_dirCtx.search(this.m_userBase, this.m_userAttr + "=*", constraints);
        ArrayList<String> users = new ArrayList<String>();
        while (results != null && results.hasMoreElements()) {
            SearchResult si = results.next();
            users.add(this.stripSuffix(si.getName() + "," + this.m_userBase));
        }
        return users.toArray(new String[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

