/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.misc;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.Socket;

public class SignalClient {
    static /* synthetic */ Class class$openwfe$org$misc$SignalClient;

    public static void sendSignal(int port, String signal) throws IOException {
        Socket socket = new Socket("127.0.0.1", port);
        PrintWriter out = new PrintWriter(socket.getOutputStream());
        out.print(signal);
        out.flush();
        out.close();
        socket.close();
    }

    private static void printUsage(String command) {
        if (command == null) {
            command = "java " + (class$openwfe$org$misc$SignalClient == null ? (class$openwfe$org$misc$SignalClient = SignalClient.class$("openwfe.org.misc.SignalClient")) : class$openwfe$org$misc$SignalClient).getName();
        }
        System.out.println("\nUSAGE :\n");
        System.out.println("   " + command + " {port} {signal}\n");
        System.out.println("      the main signal known by OpenWFE applications is 'STOP'");
        System.out.println("      {port} may be a comma separated list of ports\n");
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            SignalClient.printUsage(null);
            System.exit(2);
        }
        int index = 0;
        String command = null;
        if (args[0].equals("-c")) {
            command = args[1];
            index = 2;
        }
        if (args.length < index + 2) {
            SignalClient.printUsage(command);
            System.exit(1);
        }
        String[] sPorts = args[index++].split(",");
        String signal = args[index];
        int exitCode = 0;
        for (int i = 0; i < sPorts.length; ++i) {
            int port = Integer.parseInt(sPorts[i]);
            try {
                SignalClient.sendSignal(port, signal);
                System.out.println("Sent signal '" + signal + "' to localhost:" + port);
                continue;
            }
            catch (ConnectException ce) {
                System.out.println("Couldn't connect to port " + port);
                exitCode = 3;
            }
        }
        System.exit(exitCode);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

