/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.apache.log4j.Logger;

public class ChannelInputStream
extends InputStream {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$net$ChannelInputStream == null ? (class$openwfe$org$net$ChannelInputStream = ChannelInputStream.class$("openwfe.org.net.ChannelInputStream")) : class$openwfe$org$net$ChannelInputStream).getName());
    public static final String P_DEBUG = (class$openwfe$org$net$ChannelInputStream == null ? (class$openwfe$org$net$ChannelInputStream = ChannelInputStream.class$("openwfe.org.net.ChannelInputStream")) : class$openwfe$org$net$ChannelInputStream).getName() + ".debug";
    private static final boolean DEBUG = System.getProperty(P_DEBUG) != null && System.getProperty(P_DEBUG).toLowerCase().equals("true");
    private ReadableByteChannel channel = null;
    private int bytesRead = 0;
    private int bytesToRead = -1;
    private int maxAttempt = 10;
    private int residualByte = -1;
    static /* synthetic */ Class class$openwfe$org$net$ChannelInputStream;

    public ChannelInputStream(ReadableByteChannel channel) {
        this.channel = channel;
    }

    public ChannelInputStream(ReadableByteChannel channel, int bytesToRead) {
        this.channel = channel;
        this.bytesToRead = bytesToRead;
    }

    public ChannelInputStream(ReadableByteChannel channel, int bytesToRead, int maxAttempt) {
        this.channel = channel;
        this.bytesToRead = bytesToRead;
        this.maxAttempt = maxAttempt;
    }

    public void setMaxAttempt(int ma) {
        this.maxAttempt = ma;
    }

    public void setBytesToRead(int btr) {
        this.bytesToRead = this.bytesRead + btr;
    }

    public int read() throws IOException {
        byte[] bs;
        int i;
        if (DEBUG) {
            log.info((Object)"read()");
        }
        if ((i = this.read(0, bs = new byte[1], 0, 1)) < 1) {
            return i;
        }
        return bs[0];
    }

    public int read(byte[] ba) throws IOException {
        if (DEBUG) {
            log.info((Object)"read(ba)");
        }
        ByteBuffer buffer = ByteBuffer.wrap(ba);
        int readCount = this.channel.read(buffer);
        this.bytesRead += readCount;
        return readCount;
    }

    public int read(byte[] ba, int offset, int length) throws IOException {
        if (DEBUG) {
            log.info((Object)("read(ba, o, l) : (ba, " + offset + ", " + length + ")"));
        }
        return this.read(0, ba, offset, length);
    }

    private int read(int attempt, byte[] ba, int offset, int length) throws IOException {
        if (DEBUG) {
            log.info((Object)("read(a, ba, o, l) btr : " + this.bytesToRead + " / br : " + this.bytesRead));
        }
        if (DEBUG) {
            log.info((Object)("read(a, ba, o, l) : (" + attempt + ", ba, " + offset + ", " + length + ")"));
        }
        if (attempt > this.maxAttempt) {
            return -1;
        }
        ByteBuffer buffer = ByteBuffer.wrap(ba, offset, length);
        int readCount = this.channel.read(buffer);
        if (DEBUG) {
            log.info((Object)("read(a, ba, o, l) (" + attempt + ") readCount : " + readCount));
        }
        if (readCount == 0) {
            if (this.bytesToRead > 0 && this.bytesRead >= this.bytesToRead) {
                log.debug((Object)"read(a, ba, o, l) done.");
                return -1;
            }
            if (attempt % 5 == 4) {
                try {
                    Thread.sleep(28L);
                }
                catch (InterruptedException e) {}
            } else {
                Thread.yield();
            }
            return this.read(attempt + 1, ba, offset, length);
        }
        this.bytesRead += readCount;
        return readCount;
    }

    public void close() throws IOException {
    }

    public static BufferedReader newBufferedReader(ReadableByteChannel channel, String charsetName) throws UnsupportedEncodingException {
        return new BufferedReader(ChannelInputStream.newInputStreamReader(channel, charsetName));
    }

    public static InputStreamReader newInputStreamReader(ReadableByteChannel channel, String charsetName) throws UnsupportedEncodingException {
        return new InputStreamReader((InputStream)new ChannelInputStream(channel), charsetName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        log.info((Object)(")( emit extra debug info ? " + DEBUG));
    }
}

