/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.net;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import openwfe.org.Utils;
import openwfe.org.misc.IoUtils;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public abstract class NetUtils {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$net$NetUtils == null ? (class$openwfe$org$net$NetUtils = NetUtils.class$("openwfe.org.net.NetUtils")) : class$openwfe$org$net$NetUtils).getName());
    public static final String HTTP_EOL = "\r\n";
    public static final String DOUBLE_HTTP_EOL = "\r\n\r\n";
    private static SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH);
    static /* synthetic */ Class class$openwfe$org$net$NetUtils;

    public static byte[] channelToByteArray(ReadableByteChannel readChannel) throws IOException {
        int read;
        int zeroReadMax = 2;
        ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        WritableByteChannel writeChannel = Channels.newChannel(baos);
        int zeroReads = 0;
        while ((read = readChannel.read(buffer)) >= 0) {
            if (read == 0) {
                if (++zeroReads >= 2) break;
                Thread.currentThread();
                Thread.yield();
                continue;
            }
            zeroReads = 0;
            buffer.flip();
            writeChannel.write(buffer);
            buffer.clear();
        }
        byte[] result = baos.toByteArray();
        return result;
    }

    public static InputStream channelToInputStream(ReadableByteChannel readChannel) throws IOException {
        return new ByteArrayInputStream(NetUtils.channelToByteArray(readChannel));
    }

    public static Reader channelToReader(ReadableByteChannel readChannel) throws IOException {
        return new InputStreamReader(NetUtils.channelToInputStream(readChannel));
    }

    public static byte[] readHttpRequest(ReadableByteChannel readChannel) throws IOException {
        int zeroReads = 0;
        String requestType = null;
        ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        WritableByteChannel writeChannel = Channels.newChannel(baos);
        while (true) {
            int read = readChannel.read(buffer);
            if (log.isDebugEnabled()) {
                log.debug((Object)("readHttpRequest() read " + read + " bytes"));
            }
            if (read == 0) {
                if (++zeroReads > 3) break;
                Thread.currentThread();
                Thread.yield();
                continue;
            }
            buffer.flip();
            writeChannel.write(buffer);
            boolean reachedEol = NetUtils.isEol(buffer);
            String curReqType = NetUtils.determineRequestType(buffer);
            if (log.isDebugEnabled()) {
                log.debug((Object)("readHttpRequest() [ requestType is  " + requestType));
                log.debug((Object)("readHttpRequest()   reachedEol is   " + reachedEol));
                log.debug((Object)("readHttpRequest()   curReqType is   " + curReqType + " ]"));
            }
            if (requestType == null ? "GET".equals(requestType = curReqType) && reachedEol : reachedEol) break;
            zeroReads = 0;
            buffer.clear();
        }
        return baos.toByteArray();
    }

    private static String determineRequestType(ByteBuffer buffer) throws IOException {
        buffer.rewind();
        if (buffer.remaining() < 4) {
            return null;
        }
        byte[] ba = new byte[4];
        for (int i = 0; i < 4; ++i) {
            ba[i] = buffer.get();
        }
        String s = new String(ba, Utils.getEncoding());
        s = s.toLowerCase();
        if (log.isDebugEnabled()) {
            log.debug((Object)("determineRequestType() found >" + s + "<"));
        }
        if (s.equals("get ")) {
            return "GET";
        }
        if (s.equals("post")) {
            return "POST";
        }
        return null;
    }

    private static boolean isEol(ByteBuffer buffer) throws IOException {
        buffer.rewind();
        if (buffer.remaining() < 4) {
            return false;
        }
        buffer.position(buffer.limit() - 4);
        byte[] ba = new byte[4];
        for (int i = 0; i < 4; ++i) {
            ba[i] = buffer.get();
        }
        String s = new String(ba, Utils.getEncoding());
        return s.equals(DOUBLE_HTTP_EOL);
    }

    private static String asIntSequence(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            sb.append((int)c);
            sb.append(" ");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void httpReply(SelectionKey key, int replyCode, String message, String serverName, String[] otherHeaders, String contentType, Object body) {
        AbstractInterruptibleChannel channel = null;
        ByteArrayOutputStream baos = null;
        PrintWriter pw = null;
        try {
            NetUtils.drainInput(key);
            baos = new ByteArrayOutputStream();
            pw = new PrintWriter(baos);
            pw.print("HTTP/1.0 " + replyCode + " " + message);
            pw.print(HTTP_EOL);
            pw.print("Date: " + NetUtils.formatDate(new Date()));
            pw.print(HTTP_EOL);
            pw.print("Server: " + serverName);
            pw.print(HTTP_EOL);
            pw.print("Content-type: " + contentType);
            pw.print(HTTP_EOL);
            if (otherHeaders != null && otherHeaders.length > 0) {
                for (int i = 0; i < otherHeaders.length; ++i) {
                    pw.print(otherHeaders[i]);
                    pw.print(HTTP_EOL);
                }
            }
            pw.print(HTTP_EOL);
            if (body != null) {
                if (body instanceof Throwable) {
                    ((Throwable)body).printStackTrace(pw);
                } else if (body instanceof Element) {
                    Document doc = new Document((Element)body);
                    XMLOutputter out = XmlUtils.getXMLOutputter();
                    pw.flush();
                    out.output(doc, (OutputStream)baos);
                    baos.flush();
                } else {
                    log.debug((Object)"httpReply() body is something else");
                    pw.print(body.toString());
                }
            } else {
                pw.print("no comment.");
            }
            pw.print(HTTP_EOL);
            pw.print(HTTP_EOL);
            pw.print(HTTP_EOL);
            pw.print(HTTP_EOL);
            pw.flush();
            pw.close();
            ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
            int bytesToTransfer = buffer.capacity();
            channel = (SocketChannel)key.channel();
            int transferredBytes = 0;
            while ((transferredBytes += ((SocketChannel)channel).write(buffer)) < bytesToTransfer) {
            }
        }
        catch (Throwable t) {
            log.info((Object)"httpReply() Failed to reply to rest client", t);
        }
        finally {
            try {
                channel.close();
            }
            catch (Throwable t) {}
            try {
                key.cancel();
            }
            catch (Throwable t) {}
        }
    }

    public static String formatDate(Date d) {
        return sdf.format(d);
    }

    public static String keyStatus(SelectionKey key) {
        StringBuffer sb = new StringBuffer();
        sb.append("{ key valid:").append(key.isValid()).append(" readable:").append(key.isReadable()).append(" writable:").append(key.isWritable()).append(" channel:").append(key.channel()).append(" }");
        return sb.toString();
    }

    public static void drainInput(SelectionKey key) {
        ReadableByteChannel channel = (ReadableByteChannel)((Object)key.channel());
        int count = 0;
        int zeroReads = 0;
        try {
            int i;
            while ((i = IoUtils.read(channel)) >= 0) {
                if (i == 0) {
                    if (zeroReads < 5) {
                        ++zeroReads;
                        Thread.yield();
                        continue;
                    }
                    break;
                }
                ++count;
                zeroReads = 0;
            }
        }
        catch (Throwable t) {
            log.debug((Object)"drainInput() read failure", t);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("drainInput() found " + count + " bytes."));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

