/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.sql.ds;

import com.ibm.db2.jcc.DB2Diagnosable;
import com.ibm.db2.jcc.DB2SimpleDataSource;
import com.ibm.db2.jcc.DB2Sqlca;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.sql.ds.OwfeDataSource;
import org.apache.log4j.Logger;

public class DB2DataSource
extends OwfeDataSource {
    public static final String P_HOST = "db2Host";
    public static final String P_PORT = "db2Port";
    public static final int P_PORT_DEFAULT = 50000;
    public static final String P_USER = "db2User";
    public static final String P_PASS = "db2Pass";
    public static final String P_DBNAME = "db2Database";
    public static final String P_SCHEMA = "db2Schema";
    public static final String P_TYPE = "db2Type";
    public static final int P_TYPE_DEFAULT = 4;
    private static final String CON_VALIDITY_SQL_CODE = "select 1 from syscat.servers";

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        DB2SimpleDataSource ds = new DB2SimpleDataSource();
        ds.setDatabaseName(MapUtils.getMandatoryString(serviceParams, P_DBNAME));
        ds.setCurrentSchema(MapUtils.getMandatoryString(serviceParams, P_SCHEMA));
        ds.setServerName(MapUtils.getMandatoryString(serviceParams, P_HOST));
        ds.setPortNumber(MapUtils.getAsInt(serviceParams, P_PORT, 50000));
        ds.setUser(MapUtils.getMandatoryString(serviceParams, P_USER));
        ds.setPassword(MapUtils.getMandatoryString(serviceParams, P_PASS));
        ds.setDriverType(MapUtils.getAsInt(serviceParams, P_TYPE, 4));
        this.setDataSource((DataSource)ds);
    }

    public void logSQLException(String funcName, Logger logger, SQLException e) {
        while (e != null) {
            DB2Sqlca sqlca;
            logger.error((Object)(funcName + "() SQLException : " + e.toString()));
            if (e instanceof DB2Diagnosable && (sqlca = ((DB2Diagnosable)e).getSqlca()) != null) {
                int sqlCode = sqlca.getSqlCode();
                String sqlErrmc = sqlca.getSqlErrmc();
                String[] sqlErrmcTokens = sqlca.getSqlErrmcTokens();
                String sqlErrp = sqlca.getSqlErrp();
                int[] sqlErrd = sqlca.getSqlErrd();
                char[] sqlWarn = sqlca.getSqlWarn();
                String sqlState = sqlca.getSqlState();
                String errMessage = "";
                try {
                    errMessage = sqlca.getMessage();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                logger.error((Object)("Server error message: " + errMessage));
                logger.error((Object)"--------------- SQLCA ---------------");
                logger.error((Object)("Error code: " + sqlCode));
                logger.error((Object)("SQLERRMC: " + sqlErrmc));
                for (int i = 0; i < sqlErrmcTokens.length; ++i) {
                    logger.error((Object)("  token " + i + ": " + sqlErrmcTokens[i]));
                }
                logger.error((Object)("SQLERRP: " + sqlErrp));
                logger.error((Object)("SQLERRD(1): " + sqlErrd[0] + "\n" + "SQLERRD(2): " + sqlErrd[1] + "\n" + "SQLERRD(3): " + sqlErrd[2] + "\n" + "SQLERRD(4): " + sqlErrd[3] + "\n" + "SQLERRD(5): " + sqlErrd[4] + "\n" + "SQLERRD(6): " + sqlErrd[5]));
                logger.error((Object)("SQLWARN1: " + sqlWarn[0] + "\n" + "SQLWARN2: " + sqlWarn[1] + "\n" + "SQLWARN3: " + sqlWarn[2] + "\n" + "SQLWARN4: " + sqlWarn[3] + "\n" + "SQLWARN5: " + sqlWarn[4] + "\n" + "SQLWARN6: " + sqlWarn[5] + "\n" + "SQLWARN7: " + sqlWarn[6] + "\n" + "SQLWARN8: " + sqlWarn[7] + "\n" + "SQLWARN9: " + sqlWarn[8] + "\n" + "SQLWARNA: " + sqlWarn[9]));
                logger.error((Object)("SQLSTATE: " + sqlState));
            }
            e = e.getNextException();
        }
    }

    public String getConnectionValiditySqlCode() {
        return CON_VALIDITY_SQL_CODE;
    }
}

