/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.time;

import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;

public class CronLine {
    private int[] minutes = null;
    private int[] hours = null;
    private int[] days = null;
    private int[] months = null;
    private int[] daysOfWeek = null;

    protected CronLine() {
    }

    public boolean matches(long t) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(t);
        if (CronLine.noMatch(cal.get(12), this.minutes)) {
            return false;
        }
        if (CronLine.noMatch(cal.get(10), this.hours)) {
            return false;
        }
        if (CronLine.noMatch(cal.get(5), this.days)) {
            return false;
        }
        if (CronLine.noMatch(cal.get(2), this.months)) {
            return false;
        }
        return !CronLine.noMatch(cal.get(7), this.daysOfWeek);
    }

    private static boolean noMatch(int value, int[] cronValues) {
        if (cronValues == null) {
            return false;
        }
        for (int i = 0; i < cronValues.length; ++i) {
            if (value != cronValues[i]) continue;
            return false;
        }
        return true;
    }

    public static CronLine parse(String cronString) {
        String[] ss = cronString.split(" ");
        CronLine result = new CronLine();
        result.minutes = CronLine.parseItem(ss[0], 0, 59);
        result.hours = CronLine.parseItem(ss[1], 0, 24);
        result.days = CronLine.parseItem(ss[2], 1, 31);
        result.months = CronLine.parseItem(ss[3], 1, 12);
        result.daysOfWeek = CronLine.parseItem(ss[4], 1, 7);
        return result;
    }

    private static int[] parseItem(String s, int min, int max) {
        if (s.trim().equals("*")) {
            return null;
        }
        if (s.indexOf(",") > -1) {
            return CronLine.parseList(s, min, max);
        }
        if (s.indexOf("-") > -1 || s.indexOf("*") > -1) {
            return CronLine.parseRange(s, min, max);
        }
        int i = Integer.parseInt(s);
        if (i < min) {
            i = min;
        } else if (i > max) {
            i = max;
        }
        return new int[]{i};
    }

    private static int[] parseList(String s, int min, int max) {
        String[] ss = s.split(",");
        int[] result = new int[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            result[i] = Integer.parseInt(ss[i]);
            if (result[i] < min) {
                result[i] = min;
            }
            if (result[i] <= max) continue;
            result[i] = max;
        }
        return result;
    }

    private static int[] parseRange(String s, int min, int max) {
        int i = s.indexOf("-");
        int j = s.indexOf("/");
        int inc = 1;
        if (j > -1) {
            inc = Integer.parseInt(s.substring(j + 1));
        }
        int start = -1;
        int end = -1;
        if (i > -1) {
            start = Integer.parseInt(s.substring(0, i));
            end = j > -1 ? Integer.parseInt(s.substring(i + 1, j)) : Integer.parseInt(s.substring(i + 1));
        } else {
            start = min;
            end = max;
        }
        if (start < min) {
            start = min;
        }
        if (end > max) {
            end = max;
        }
        LinkedList<Integer> list = new LinkedList<Integer>();
        for (int value = start; value <= end; value += inc) {
            list.add(new Integer(value));
        }
        int index = 0;
        int[] result = new int[list.size()];
        Iterator it = list.iterator();
        while (it.hasNext()) {
            result[index++] = (Integer)it.next();
        }
        return result;
    }
}

