/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: Utils.java 3242 2006-09-10 04:15:06Z jmettraux $
 */

//
// Utils.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org;

import openwfe.org.misc.ByteUtils;


/**
 * Static methods for misc usages
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-09-10 06:15:06 +0200 (Sun, 10 Sep 2006) $
 * <br>$Id: Utils.java 3242 2006-09-10 04:15:06Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class Utils
{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(Utils.class.getName());


    /**
     * Turns a serializable object into a byte array
     */
    public static byte[] serialize (java.io.Serializable object)
        throws java.io.IOException
    {
        java.io.ByteArrayOutputStream baos =
            new java.io.ByteArrayOutputStream();
        java.io.ObjectOutputStream oos =
            new java.io.ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.flush();

        return baos.toByteArray();
    }

    /** 
     * (not very much used these days)
     */
    public static String getMd5Digest (byte[] data)
    {
        java.security.MessageDigest digest = null;
        try
        {
            digest = java.security.MessageDigest.getInstance("MD5");
        }
        catch (java.security.NoSuchAlgorithmException nsae)
        {
            log.warn("cannot compute MD5 digest", nsae);
            return null;
        }

        digest.update(data);

        return ByteUtils.toString(digest.digest());
    }

    /**
     * Given a List l, locates the elt thisObject in it and replaces it with
     * thatObject.
     */
    public static boolean replace 
        (final java.util.List l, 
         final Object thisObject, 
         final Object thatObject)
    {
        synchronized (l)
        {
            int index = -1;

            for (int i=0; i<l.size(); i++)
            {
                final Object o = l.get(i);

                if (o.equals(thisObject))
                {
                    index = i;
                    break;
                }
            }

            if (index > -1)
            {
                l.remove(index);
                l.add(index, thatObject);
                return true;
            }

            return false;
        }
    }

    /**
     * given a map of string &lt;-&gt; integers, adds one to the integer
     * corresponding to the given key
     */
    public static void inc (final java.util.Map map, final String key)
    {
        inc(map, key, 1);
    }

    /**
     * given a map of string &lt;-&gt; integers, adds one to the integer
     * corresponding to the given key
     */
    public static void inc 
        (final java.util.Map map, final String key, final int count)
    {
        Integer ii = (Integer)map.get(key);
        if (ii == null) ii = new Integer(0);
        ii = new Integer(ii.intValue() + count);
        map.put(key, ii);
    }

    /**
     * precondition : the 2 values are not null
     */
    public static int compareValues 
        (final Object value, final Object otherValue)
    {
        //
        // try numeric comparison first
        
        try
        {
            double dVal = Double.parseDouble(value.toString());
            double dOtherVal = Double.parseDouble(otherValue.toString());

            return (int)(dVal - dOtherVal);
        }
        catch (NumberFormatException nfe)
        {
            // forget it
            //log.debug("non numeric values, proceeding with string comparison");
        }

        //
        // string comparison else
        
        return (value.toString().compareTo(otherValue.toString()));
    }

    /**
     * Returns true if the o.toString() equals "true" or "false"
     * (case is not relevant).
     * If the object is null, will return false.
     */
    public static boolean toBoolean (final Object o)
    {
        if (o == null) return false;

        String s = o.toString().toLowerCase().trim();

        return 
            ("yes".equals(s) || 
             "ok".equals(s) ||
             "true".equals(s) ||
             "on".equals(s));
    }

    /**
     * Like toBoolean(o), but if o is null will return defaultValue instead
     * of 'false'.
     */
    public static boolean toBoolean 
        (final Object o, final boolean defaultValue)
    {
        if (o == null) return defaultValue;

        return toBoolean(o);
    }

    /**
     * Returns the encoding for the system
     * by default, it's ISO-8859-1.
     * Can be set by changing the ENCODING system property.
     */
    public static String getEncoding ()
    {
        return System.getProperty("openwfe.xml.encoding", "ISO-8859-1");
    }

    /**
     * As getEncoding() returns the String value of the encoding to user,
     * this method returns the corresponding charset.
     */
    public static java.nio.charset.Charset getCharset ()
    {
        return java.nio.charset.Charset.forName(getEncoding());
    }

    /**
     * Returns a copy of a String (or null if the in string is null)
     */
    public static String copyString (String in)
    {
        if (in == null) return null;
        return new String(in);
    }

    /**
     * This method is useful for printing stack traces from a JSP : it accepts 
     * the 'out' writer has parameter.
     */
    public static void printStackTrace 
        (final Throwable t, final java.io.Writer w)
    {
        java.io.PrintWriter pw = new java.io.PrintWriter(w);
        t.printStackTrace(pw);
        pw.flush();
    }

    /**
     * Dumps a stack trace in a String.
     */
    public static String stackTraceToString (final Throwable t)
    {
        final java.io.StringWriter sw = new java.io.StringWriter();
        final java.io.PrintWriter pw = new java.io.PrintWriter(sw);

        t.printStackTrace(pw);

        pw.flush();

        return sw.toString();
    }

    /**
     * Outputs at DEBUG level the content of a map
     */
    public static void debugMap 
        (final org.apache.log4j.Logger log,
         final java.util.Map map)
    {
        if ( ! log.isDebugEnabled()) return;

        final StringBuffer sb = new StringBuffer();

        sb.append("\n*** debugMap ***\n");

        final java.util.Iterator it = map.keySet().iterator();
        while (it.hasNext())
        {
            final Object key = it.next();
            final Object value = map.get(key);

            sb.append("   * ");
            sb.append(key);
            sb.append("   -->  ");
            sb.append(value);
            sb.append("\n");
        }

        log.debug(sb.toString());
    }

    /**
     * Simply returning the platform dependent temp directory.
     */
    public static String getTempDir ()
    {
        return System.getProperty("java.io.tmpdir");
    }

    /**
     * A method for dumping data in a temp file. Returns the filename.
     */
    public static String dump (final String prefix, final byte[] data)
    {
        try
        {
            final java.io.File tempFile = 
                java.io.File.createTempFile(prefix, ".dmp");

            if (log.isDebugEnabled())
                log.debug("dump() to "+tempFile.getPath());

            final java.io.FileOutputStream fos = 
                new java.io.FileOutputStream(tempFile);

            fos.write(data);
            fos.flush();
            fos.close();

            return tempFile.getPath();
        }
        catch (final Throwable t)
        {
            if (log.isDebugEnabled())
                log.debug("dump() failure "+t);
        }

        return null;
    }

    /**
     * Logs the current stack trace.
     */
    public static void logStackTrace 
        (final org.apache.log4j.Logger log,
         final String message)
    {
        try
        {
            throw new Exception("openwfe.org.Utils.logStackTrace()");
        }
        catch (final Exception e)
        {
            log.info(message, e);
        }
    }

    /**
     * Logs the current stack trace.
     */
    public static void logStackTrace 
        (final org.apache.log4j.Logger log)
    {
        logStackTrace(log, "logStackTrace()");
    }

    /**
     * Copies a map (returns a brand new HashMap).
     */
    public static java.util.Map copyHashMap (final java.util.Map m)
    {
        if (m == null) return null;

        final java.util.Map copy = new java.util.HashMap(m.size());

        /*
        final java.util.Iterator it = m.entrySet().iterator();
        while (it.hasNext())
        {
            final java.util.Map.Entry e = (java.util.Map.Entry)it.next();

            copy.put(e.getKey(), e.getValue());
        }
        */

        copy.putAll(m);

        return copy;
    }

    /**
     * Returns the first element in the list that is of the given class.
     */
    public static Object getFirstElementOfClass 
        (final java.util.List l, final Class clazz)
    {
        final java.util.Iterator it = l.iterator();
        while (it.hasNext())
        {
            final Object o = it.next();

            if (clazz.isAssignableFrom(o.getClass())) return o;
        }

        return null;
    }

    /**
     * Returns the last element in the list that is of the given class.
     */
    public static Object getLastElementOfClass
        (final java.util.List l, final Class clazz)
    {
        for (int i = l.size(); i > 0; i--)
        {
            final Object o = l.get(i-1);

            if (clazz.isAssignableFrom(o.getClass())) return o;
        }

        return null;
    }

    /**
     * Turns a list to an array of String.
     */
    public static String[] toStringArray (final java.util.List l)
    {
        if (l == null) return null;

        final String[] ss = new String[l.size()];

        for (int i=0; i<l.size(); i++)
            ss[i] = l.get(i).toString();

        return ss;
    }

    /**
     * A NPE-safe equals; if one of the two parameters is null, will return
     * false.
     */
    public static boolean equals (final Object o1, final Object o2)
    {
        if (o1 == null || o2 == null) return false;

        return o1.equals(o2);
    }

    /**
     * A NPE-safe equals; if one of the two parameters is null, will return
     * false, but that method will return true if both args are null.
     */
    public static boolean nequals (final Object o1, final Object o2)
    {
        if (o1 == null && o2 == null) return true;

        return equals(o1, o2);
    }

    /**
     * Compares for equality the elements of both lists. If at least one list
     * is null, this method will immediately return false.
     */
    public static boolean listEquals 
        (final java.util.List l1, final java.util.List l2)
    {
        //int di=0;
        //log.debug("listEquals() "+(di++));

        if (l1 == null || l2 == null) return false;

        //log.debug("listEquals() "+(di++));

        if (l1.size() != l2.size()) return false;

        //log.debug("listEquals() "+(di++));

        for (int i=0; i<l1.size(); i++)
        {
            if ( ! l1.get(i).equals(l2.get(i)))
            {
                //log.debug("listEquals() "+l1.get(i)+" != "+l2.get(i));
                return false;
            }
        }

        //log.debug("listEquals() "+(di++));

        return true;

        // the debug in this method was added in the Starbucks
        // at the ground floor of the Landmark Tower in Yokohama.jp
        // no wireless...  Sun Aug 27 09:04:31 CEST 2006
    }

    /**
     * Equivalent to equals(), but takes care of turning o1 and o2 to 
     * strings and does check the equality of the strings.
     */
    public static boolean toStringEquals (final Object o1, final Object o2)
    {
        if (o1 == null || o2 == null) return false;

        return o1.toString().equals(o2.toString());
    }

    /**
     * returns true if the two strings are equal,
     * returns false as soon as one of them is null, or
     * if they are not equals
     */
    public static boolean stringEquals (final String s1, final String s2)
    {
        if (s1 == null && s2 == null) return true;

        if (s1 == null || s2 == null) return false;

        return s1.equals(s2);
    }

    /**
     * Just outputs the first chars of a [potentially long] string.
     */
    public static String summarize (final String s, final int maxLength)
    {
        if (s == null) return "null";
        if (s.length() < maxLength) return s;
        
        return s.substring(0, maxLength-3) + "...";
    }

    /**
     * Equivalent to summarize(s, 10)
     */
    public static String summarize (final String s)
    {
        return summarize(s, 10);
    }

}
