/*
 * Copyright (c) 2004-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ServiceAction.java 3090 2006-08-30 09:06:14Z jmettraux $
 */

//
// ServiceAction.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.actions;

import openwfe.org.ServiceException;


/**
 * An action on a service or another instance.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 11:06:14 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: ServiceAction.java 3090 2006-08-30 09:06:14Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class ServiceAction

    implements java.security.PrivilegedExceptionAction

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(ServiceAction.class.getName());

    //
    // FIELDS

    protected Object target = null;
    protected String methodName = null;
    protected Object[] args = null;

    //
    // CONSTRUCTORS

    public ServiceAction 
        (final Object target,
         final String methodName,
         final Object[] args)
    {
        this.target = target;
        this.methodName = methodName;
        this.args = args;
    }

    //
    // METHODS from PrivilegedExceptionAction

    public Object run ()
        throws java.security.PrivilegedActionException
    {
        try
        {
            if (this.target == null)
            {
                throw new ServiceException("Object or Service not found");
            }

            if (log.isDebugEnabled())
            {
                log.debug
                    ("Running for method '"+this.methodName+
                     "' on target of class '"+this.target.getClass().getName()+
                     "'");
            }

            Class targetClass = this.target.getClass();

            java.lang.reflect.Method method = null;
            java.lang.reflect.Method[] ms = targetClass.getMethods();
            for (int i=0; i<ms.length; i++)
            {
                if ( ! ms[i].getName().equals(this.methodName)) continue;

                if (sameAsArgs(ms[i]))
                {
                    method = ms[i];
                    break;
                }
            }

            if (method == null)
            {
                throw new NoSuchMethodException
                    ("No method '"+this.methodName+
                     "' found with matching parameters");
            }

            return
                method.invoke(this.target, this.args);
        }
        catch (Exception e)
        {
            throw new java.security.PrivilegedActionException(e);
        }
    }

    //
    // METHODS

    private Class[] getClassArgs ()
    {
        Class[] result = new Class[this.args.length];

        for (int i=0; i<this.args.length; i++)
        {
            result[i] = this.args[i].getClass();
        }

        return result;
    }

    private boolean sameAsArgs (java.lang.reflect.Method method)
    {
        if (method.getParameterTypes().length != this.args.length)
            return false;

        Class[] classArgs = getClassArgs();

        for (int i=0; i<classArgs.length; i++)
        {
            if (log.isDebugEnabled())
            {
                log.debug
                    ("is '"+method.getParameterTypes()[i].getName()+
                     "' assignable from '"+classArgs[i]+"'");
            }

            if ( ! method.getParameterTypes()[i].isAssignableFrom(classArgs[i]))
            {
                return false;
            }
        }

        return true;
    }

}
