/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ServicePermission.java 2713 2006-06-01 14:38:45Z jmettraux $
 */

//
// ServicePermission.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.auth;

import java.security.PermissionCollection;


/**
 * A generic permission, with a list of actions.
 *
 * There is a name wildcard "*" and a actionList wildcard [ "*" ]
 * i.e. new ServicePermission("*", "*"); allows everything
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-06-01 16:38:45 +0200 (Thu, 01 Jun 2006) $
 * <br>$Id: ServicePermission.java 2713 2006-06-01 14:38:45Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class ServicePermission

    extends Permission

{

    private final static org.apache.log4j.Logger log =
        org.apache.log4j.Logger.getLogger(ServicePermission.class.getName());

    //
    // CONSTANTS (definitions)

    public final static String ACTIONS 
        = "actions";

    //
    // FIELDS

    private java.util.List actionList = null;

    //
    // CONSTRUCTORS

    public ServicePermission (java.util.Map params)
    {
        super(params);

        buildActionList((String)params.get(ACTIONS));
    }

    //
    // METHODS

    private void buildActionList (String actions)
    {
        String[] ss = actions.split(", *");

        this.actionList = new java.util.ArrayList(ss.length);

        for (int i=0; i<ss.length; i++)
        {
            this.actionList.add(ss[i].trim().toLowerCase());
        }

        java.util.Collections.sort(this.actionList);
    }

    private boolean isActionListEqual (ServicePermission other)
    {
        if (this.actionList.size() != other.actionList.size()) return false;

        java.util.Iterator it = this.actionList.iterator();
        while (it.hasNext())
        {
            String action = (String)it.next();

            if ( ! other.actionList.contains(action)) return false;
        }
        
        return true;
    }

    private boolean isActionWildCard ()
    {
        return 
            (this.actionList.size() == 1 &&
             ((String)this.actionList.get(0)).equals("*"));
    }

    private boolean actionImplies (ServicePermission other)
    {
        if (this.isActionWildCard()) return true;

        if (this.actionList.size() < other.actionList.size()) return false;

        java.util.Iterator it = other.actionList.iterator();
        while (it.hasNext())
        {
            String action = (String)it.next();

            if ( ! this.actionList.contains(action)) return false;
        }

        return true;
    }

    public String actionListToString ()
    {
        StringBuffer sb = new StringBuffer();

        java.util.Iterator it = this.actionList.iterator();
        while (it.hasNext())
        {
            sb.append((String)it.next());

            if (it.hasNext()) sb.append(", ");
        }

        return sb.toString();
    }

    //
    // METHODS from Permission

    public String getActions ()
    {
        return actionListToString();
    }

    public int hashCode ()
    {
        return 
            (this.getName().hashCode() + this.actionList.hashCode());
    }

    public boolean equals (Object o)
    {
        if ( ! (o instanceof ServicePermission)) return false;

        ServicePermission other = (ServicePermission)o;

        return 
            (getName().equals(other.getName()) &&
             isActionListEqual(other));
    }

    public boolean implies (java.security.Permission p)
    {
        if (p == null || ! (p instanceof ServicePermission)) return false;

        ServicePermission other = (ServicePermission)p;

        if (log.isDebugEnabled())
            log.debug("does "+this+" implies "+other+" ?");

        //
        // for the moment, a store permission doesn't target 
        // multiple stores through a re system...

        if ( ! (getName().equals(other.getName()) ||
                getName().trim().equals("*")))
        {
            return false;
        }

        //
        // check the actions

        return actionImplies(other);
    }

    public PermissionCollection newPermissionCollection ()
    {
        return new ServicePermissionCollection();
    }

    public String toString ()
    {
        StringBuffer sb = new StringBuffer();

        sb.append("<ServicePermission name=\"");
        sb.append(getName());
        sb.append("\" actions=\"");
        sb.append(actionListToString());
        sb.append("\" />");

        return sb.toString();
    }

}

//
// ANOTHER CLASS

//
// ServicePermissionCollection.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

/**
 * no comment
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-06-01 16:38:45 +0200 (Thu, 01 Jun 2006) $
 * <br>$Id: ServicePermission.java 2713 2006-06-01 14:38:45Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
final class ServicePermissionCollection

    extends PermissionCollection

    implements java.io.Serializable

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(ServicePermissionCollection.class.getName());
    */

    //
    // FIELDS

    private java.util.Vector permissions = new java.util.Vector();

    //
    // CONSTRUCTORS

    //
    // METHODS

    public void add (final java.security.Permission p)
    {
        if (p == null || ! (p instanceof ServicePermission))
        {
            throw new IllegalArgumentException
                ("null permission or permission not of class '"+
                 ServicePermission.class.getName()+"'");
        }

        if (isReadOnly())
        {
            throw new SecurityException
                ("attempt to add a Permission to a readonly "+
                 "PermissionCollection");
        }

        this.permissions.add(p);
    }

    public boolean implies (java.security.Permission p)
    {
        if (p == null || ! (p instanceof ServicePermission)) return false;

        ServicePermission other = (ServicePermission)p;

        java.util.Enumeration en = elements();

        while(en.hasMoreElements())
        {
            ServicePermission sp = (ServicePermission)en.nextElement();

            //log.debug("does "+sp+" implies "+p+" ?");

            if (sp.implies(other)) return true;
        }

        return false;
    }

    public java.util.Enumeration elements ()
    {
        return this.permissions.elements();
    }

}

