/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: Actions.java 3077 2006-08-30 06:01:05Z jmettraux $
 */

//
// OwfeAction.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.auth.actions;

import javax.security.auth.Subject;
import openwfe.org.ApplicationContext;


/**
 * An abstract version of an OwfeAction
 *
 * <p><font size=2>CVS Info :
 * <br>$Author$
 * <br>$Id$ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class OwfeAction

    implements java.security.PrivilegedExceptionAction

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(OwfeAction.class.getName());
    */

    //
    // CONSTANTS & co

    //
    // FIELDS

    private ApplicationContext applicationContext = null;
    private Subject subject = null;

    private Object[] arguments = null;

    //
    // CONSTRUCTORS

    /**
     * Theses action all have an unique no-param constructor and
     * a init method.
     */
    public OwfeAction ()
    {
        super();
    }

    /**
     * Theses action all have an unique no-param constructor and
     * a init method.
     */
    public void init
        (final ApplicationContext applicationContext,
         final Subject subject,
         final Object[] args)
    {
        this.applicationContext = applicationContext;
        this.subject = subject;
        this.arguments = args;
    }

    //
    // GETTERS and SETTERS

    public ApplicationContext getContext ()
    {
        return this.applicationContext;
    }

    public Subject getSubject ()
    {
        return this.subject;
    }

    /**
     * Returns the action arguments.
     */
    public Object[] getArgs ()
    {
        return this.arguments;
    }

    //
    // ABSTRACT METHODS

    //
    // METHODS

    //
    // STATIC METHODS

}
