/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: XmlPasswdCodec.java 3240 2006-09-08 02:36:09Z jmettraux $
 */

//
// XmlPasswdCodec.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

//
// What this class should be able to decode :
//

package openwfe.org.auth.xml;

import openwfe.org.FileUtils;
import openwfe.org.Parameters;
import openwfe.org.ApplicationContext;
import openwfe.org.xml.XmlUtils;
import openwfe.org.util.ReflectionUtils;
import openwfe.org.auth.Grant;
import openwfe.org.auth.Passwd;
import openwfe.org.auth.Principal;
import openwfe.org.auth.Permission;
import openwfe.org.auth.PasswdCodec;
import openwfe.org.auth.AuthException;


/**
 * The default implementation of PasswdCodec
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-09-08 04:36:09 +0200 (Fri, 08 Sep 2006) $
 * <br>$Id: XmlPasswdCodec.java 3240 2006-09-08 02:36:09Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public class XmlPasswdCodec

    implements PasswdCodec

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(XmlPasswdCodec.class.getName());

    //
    // CONSTANTS and definitions

    public final static String NAME = "name";
    public final static String CLASS = "class";
    public final static String GRANT = "grant";
    public final static String PASSWD = "passwd";
    public final static String CODEBASE = "codebase";
    public final static String PRINCIPAL = "principal";
    public final static String PERMISSION = "permission";

    private final static XmlPermissionCodec permissionCodec = 
        new XmlPermissionCodec();

    private final static XmlPrincipalCodec principalCodec =
        new XmlPrincipalCodec();

    //
    // FIELDS

    private org.jdom.Element rootElement = null;
        // keep it for children classes
        
    private java.net.URL docUrl = null;
        // keep track of the source file.

    private ApplicationContext context = null;
    private java.util.Map serviceParams = null;

    private Passwd decodedPasswd = null;
    private long lastModified = 0;

    //
    // CONSTRUCTORS

    public void init
        (final ApplicationContext context,
         final java.util.Map serviceParams)
    {
        this.context = context;
        this.serviceParams = serviceParams;
    }

    //
    // METHODS from PasswdCodec

    private Object doEncodePasswd (final Passwd p)
        throws AuthException
    {
        org.jdom.Element ePasswd = new org.jdom.Element(PASSWD);

        ePasswd.setAttribute (NAME, p.getName());

        //
        // output principals
        
        java.util.Iterator it = p.getPrincipalMap().values().iterator();
        while (it.hasNext())
        {
            ePasswd.addContent
                ((org.jdom.Element)principalCodec.encodePrincipal
                    ((Principal)it.next(), null, null));
        }

        //
        // output grants
        
        it = p.getGrantMap().values().iterator();
        while (it.hasNext())
        {
            ePasswd.addContent(encodeGrant((Grant)it.next()));
        }

        //
        // return result

        return ePasswd;
    }

    /**
     * Writes the current state of the Passwd object to file (as an XML
     * document).
     */
    public void encodePasswd 
        (final Passwd p) 
    throws 
        AuthException
    {
        org.jdom.Element ePasswd = (org.jdom.Element)doEncodePasswd(p);

        try
        {
            String fileName = this.docUrl.toString();
            if (fileName.startsWith("file:")) fileName = fileName.substring(5);

            final java.io.FileWriter writer = new java.io.FileWriter(fileName);

            final org.jdom.output.XMLOutputter out = XmlUtils.getXMLOutputter();

            out.output(new org.jdom.Document(ePasswd), writer);
        }
        catch (final java.io.IOException ie)
        {
            throw new AuthException
                ("Failed to output passwd back to "+this.docUrl, ie);
        }
    }

    /**
     * Reads an XML document to build a Passwd object (the document is know
     * from the application context and the serviceParams as set during 
     * init()).
     */
    public Passwd decodePasswd ()
        throws AuthException
    {
        return decodePasswd(null);
    }

    /**
     * Reads an XML document to build a Passwd object.
     */
    public Passwd decodePasswd 
        (final Object o)
    throws 
        AuthException
    {
        this.docUrl = null;

        try
        {
            if (o != null)
            {
                if (o instanceof String)
                {
                    String rawUrl = (String)o;

                    rawUrl = FileUtils.expandUrl
                        (context.getApplicationDirectory(), rawUrl);

                    //this.docUrl = new java.net.URL(rawUrl);
                    this.docUrl = FileUtils.toUrl(rawUrl);
                }
                else if (o instanceof java.net.URL)
                {
                    this.docUrl = (java.net.URL)o;
                }
            }
            else if (serviceParams != null)
            {
                String sDocUrl = (String)serviceParams.get(PASSWD);

                sDocUrl = FileUtils.expandUrl
                    (context.getApplicationDirectory(), sDocUrl);

                //this.docUrl = new java.net.URL(sDocUrl);
                this.docUrl = FileUtils.toUrl(sDocUrl);
            }
            else
            {
                log.error("decodePasswd() no info for building passwd...");
            }
        }
        catch (final java.net.MalformedURLException e)
        {
            throw new AuthException
                ("Cannot extract xml out of object >"+o+"<", 
                 e);
        }

        if (this.docUrl == null)
        {
            throw new AuthException
                ("Cannot turn your >"+o+"< into a Passwd instance.");
        }

        //
        // should we reload ?

        long modified = -1;
        try
        {
            final java.net.URLConnection con = this.docUrl.openConnection();

            modified = con.getLastModified();
        }
        catch (final java.io.IOException ie)
        {
            log.warn("decodePasswd() failed to connect to "+this.docUrl);
        }

        log.debug("decodePasswd() modified       : "+modified);
        log.debug("decodePasswd() lastModified   : "+this.lastModified);

        if (this.lastModified < 1 || 
            this.lastModified < modified)
        //
        // yes, we should [re]load
        {
            log.debug("decodePasswd() reloading...");

            //
            // extract xml

            try
            {
                this.rootElement = XmlUtils.extractXml(this.docUrl, false);
            }
            catch (final Exception e)
            {
                throw new AuthException
                    ("Failed to decode XML document '"+this.docUrl+"'", e);
            }

            //
            // decode
            
            this.decodedPasswd = decode(this.rootElement);
            this.lastModified = modified;
        }

        return this.decodedPasswd;
    }

    //
    // METHODS

    protected java.util.Map extractAttributes (org.jdom.Element elt)
    {
        java.util.Map result = new java.util.HashMap();

        java.util.Iterator it = elt.getAttributes().iterator();
        while (it.hasNext())
        {
            org.jdom.Attribute a = (org.jdom.Attribute)it.next();
            result.put(a.getName(), a.getValue());
        }

        return result;
    }

    protected Grant extractGrant (org.jdom.Element elt)
        throws AuthException
    {
        String name = elt.getAttributeValue(NAME);
        String url = elt.getAttributeValue(CODEBASE);

        java.util.Set permissions = new java.util.HashSet();

        java.util.Iterator it = elt.getChildren(PERMISSION).iterator();
        while (it.hasNext())
        {
            java.security.Permission p = 
                permissionCodec.decodePermission((org.jdom.Element)it.next());
            permissions.add(p);
        }

        try
        {
            return new Grant(name, url, permissions);
        }
        catch (Exception e)
        {
            throw new AuthException
                ("Failed to extract Grant", e);
        }
    }

    protected Passwd decode (org.jdom.Element elt)
        throws AuthException
    {
        if ( ! elt.getName().equals(PASSWD))
        {
            throw new AuthException
                ("Waiting for xml element named '"+PASSWD+
                 "' not '"+elt.getName()+"'.");
        }

        //
        // extract name
        
        String name = elt.getAttributeValue(NAME);
        if (name == null) name = "passwd";
        name = name.trim();

        log.info("decode() Passwd name is '"+name+"'");

        //
        // extract principals
        
        //java.util.Map principalMap = new java.util.HashMap();
        java.util.List principals = new java.util.ArrayList(40);
        
        java.util.Iterator it = elt.getChildren(PRINCIPAL).iterator();
        while (it.hasNext())
        {
            Principal p = principalCodec.decodePrincipal(null, it.next());

            //principalMap.put(p.getName(), p);
            principals.add(p);

            //log.debug("decode() put '"+p.getName()+"'  ("+p+")");
        }

        //
        // extract grants
        
        java.util.Map grantMap = new java.util.HashMap();
        
        it = elt.getChildren(GRANT).iterator();
        while (it.hasNext())
        {
            Grant g = null;
            try
            {
                g = extractGrant((org.jdom.Element)it.next());
            }
            catch (AuthException ae)
            {
                log.warn("decode() failed to decode a Grant. Skipped it.", ae);
                continue;
            }

            grantMap.put(g.getName(), g);
        }

        //
        // build passwd
        
        return 
            //new Passwd(name, principalMap, grantMap);
            new Passwd(name, principals, grantMap);
    }

    protected org.jdom.Element encodeGrant (Grant grant)
    {
        org.jdom.Element eGrant = new org.jdom.Element(GRANT);

        //
        // encode grant
        
        eGrant.setAttribute(NAME, grant.getName());
        eGrant.setAttribute(CODEBASE, grant.getUrl());

        //
        // encode permissions
        
        java.util.Enumeration en = grant.getPermissions().elements();
        while (en.hasMoreElements())
        {
            Permission p = (Permission)en.nextElement();
            try
            {
                org.jdom.Element ePermission = 
                    permissionCodec.encodePermission(p);

                eGrant.addContent(ePermission);
            }
            catch (AuthException ae)
            {
                log.warn
                    ("Failed to encode a Permission of grant '"+
                     grant.getName()+"'", ae);
            }
        }

        return eGrant;
    }

    //
    // INNER CLASSES

    private static class XmlPermissionCodec
    {

        /*
        private final static org.apache.log4j.Logger log = 
            org.apache.log4j.Logger
                .getLogger(XmlPermissionCodec.class.getName());
        */

        //
        // CONSTANTS & co

        //
        // FIELDS

        //
        // CONSTRUCTORS

        //
        // METHODS

        public org.jdom.Element encodePermission (Permission p)
            throws AuthException
        {
            org.jdom.Element result = new org.jdom.Element(PERMISSION);

            java.util.Map params = p.getParameters();
            java.util.Iterator it = params.keySet().iterator();
            while (it.hasNext())
            {
                String key = (String)it.next();
                String value = (String)params.get(key);

                result.setAttribute(key, value);
            }
            result.setAttribute(CLASS, p.getClass().getName());

            return result;
        }

        public Permission decodePermission (org.jdom.Element e)
            throws AuthException
        {
            try
            {
                java.util.Map params = Parameters.extractAttributes(e);

                String className = (String)params.get(CLASS);
                Class permissionClass = Class.forName(className);

                final Permission p = (Permission)ReflectionUtils
                    .buildInstance(permissionClass, params);

                //log.debug("decodePermission() decoded "+p);

                return p;
            }
            catch (Exception ex)
            {
                throw new AuthException
                    ("Failed to decode permission", ex);
            }
        }

        //
        // PRIVATE METHODS

        //
        // STATIC METHODS

    }

}
