/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: SignalService.java 2713 2006-06-01 14:38:45Z jmettraux $
 */

//
// SignalService.java
//
// john.mettraux
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.misc;

import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;

import openwfe.org.net.NetUtils;
import openwfe.org.net.SocketService;
import openwfe.org.ServiceException;


/**
 * A service that listens on a TCP port and waits for signals :
 * currently, only the STOP signal is implemented.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: SignalService.java 2713 2006-06-01 14:38:45Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class SignalService

    extends SocketService

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(SignalService.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS from SocketService

    /**
     * How an incoming socket connection is treated.
     */
    public void handle (final SelectionKey key)
        throws ServiceException
    {
        SocketChannel channel = null;
        java.io.BufferedReader br = null;
        try
        {
            channel = (SocketChannel)key.channel();

            if (log.isDebugEnabled())
            {
                log.debug
                    ("handle() conn from "+
                     channel.socket().getInetAddress());
            }

            if ( ! "/127.0.0.1".equals
                    (channel.socket().getInetAddress().toString()))
            {
                channel.close();
                return;
            }

            br = new java.io.BufferedReader(NetUtils.channelToReader(channel));

            final String signal = br.readLine();

            if (log.isDebugEnabled())
                log.debug("handle() received signal >"+signal+"<");

            if (signal.equals("STOP"))
            {
                getContext().stop();

                log.info("exiting....................");

                System.exit(-7);
            }

            if (signal.equals("PAUSE"))
            {
                getContext().pause();
            }
            else if (signal.equals("PLAY"))
            {
                getContext().play();
            }
            else if (signal.equals("STATE"))
            {
                // returns the current state of the application
                sendState(channel);
            }
        }
        catch (final Exception e)
        {
            log.warn("handle() signal problem", e);
        }
        finally
        {
            try { br.close(); } catch (final Throwable t) { }
            try { channel.close(); } catch (final Throwable t) { }
        }
    }

    private void sendState (final SocketChannel channel)
        throws java.io.IOException
    {
        final String sState = getContext().getState().toString() + "\n";
        final ByteBuffer bState = ByteBuffer.wrap(sState.getBytes());

        channel.write(bState);

        //channel.flush();
        // no flush method for channels...
    }

    //
    // METHODS from Service

    /*
    public org.jdom.Element getStatus ()
    {
        return new org.jdom.Element(this.getName());
    }
    */

    //
    // STATIC METHODS

}
