/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: RemoteService.java 2321 2006-02-03 20:59:14Z jmettraux $
 */

//
// RemoteService.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.rmi;

import java.rmi.registry.Registry;
import java.rmi.registry.LocateRegistry;

import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import openwfe.org.state.StoppedState;


/**
 * A service for hosting RMI servers...
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-02-03 21:59:14 +0100 (Fri, 03 Feb 2006) $
 * <br>$Id: RemoteService.java 2321 2006-02-03 20:59:14Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public class RemoteService

    extends LocalRemoteService

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(RemoteService.class.getName());

    //
    // CONSTANTS (definitions)

    public final static String PORT
        = "port";

    //
    // FIELDS

    private Registry registry = null;

    //
    // CONSTRUCTORS

    //
    // METHODS from Service

    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {
        super.init(serviceName, context, serviceParams);

        localInit();

        //
        // define RMI registry port
        
        int port = MapUtils.getAsInt(getParams(), PORT, 1099);
            //
            // default is the classical 1099 RMI port

        //
        // bind server
        
        try
        {
            this.registry = LocateRegistry.getRegistry(port);

            try
            {
                this.registry.rebind(getRemoteName(), getRemote());
            }
            catch (final java.rmi.ConnectException ce)
            {
                //log.debug
                //    ("init() failed to locate registry on port "+port+
                //     ". Creating it.", ce);

                this.registry = LocateRegistry.createRegistry(port);
                this.registry.rebind(getRemoteName(), getRemote());
            }

            log.info
                ("init() Service bound in rmi registry "+port+
                 " under name '"+getRemoteName()+"'");
        }
        catch (final Exception e)
        {
            log.warn
                ("init() Failed to bind an remote instance under name"+
                 " '"+getRemoteName()+"' on port "+port,
                 e);
            throw new ServiceException
                ("Failed to bind an remote instance under name"+
                 " '"+getRemoteName()+"' on port "+port);
        }

        log.info
            ("Serving on rmi port "+port);
    }

    public void stop ()
        throws ServiceException
    {
        this.setState(new StoppedState());

            // skipping superclass stop

        try
        {
            this.registry.unbind(getRemoteName());
        }
        catch (Exception e)
        {
            log.info("stop() Something wicked happened during unbind", e);
            return;
        }

        log.info("stop() Unbound server '"+getRemoteName()+"'");
    }

    //
    // METHODS

}
