/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: StatusService.java 3077 2006-08-30 06:01:05Z jmettraux $
 */

//
// StatusService.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.00 16.08.2003 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.status;

import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.channels.ReadableByteChannel;

import openwfe.org.Service;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import openwfe.org.net.NetUtils;
import openwfe.org.net.SocketService;
import openwfe.org.xml.XmlUtils;


/**
 * This services serves (HTTP) the xml document generated by the
 * getStatus method of other services
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: StatusService.java 3077 2006-08-30 06:01:05Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class StatusService

    extends SocketService

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(StatusService.class.getName());

    //
    // CONSTANTS & co

    public final static String SERVER_NAME
        = "$Id: StatusService.java 3077 2006-08-30 06:01:05Z jmettraux $";

    public final static String STATUS
        = "status";

    public final static String NO_SERVICE
        = "no-such-service";

    public final static String PARAM
        = "param";

    public final static String NAME
        = "param-name";

    public final static String VALUE
        = "param-value";

    //
    // FIELDS

    //
    // CONSTRUCTORS

    /*
    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {
        super.init
            (serviceName,
             context,
             serviceParams);
    }
    */

    //
    // METHODS from Service

    //
    // METHODS from SocketService

    /**
     * This method services incoming status requests.
     */
    public void handle (SelectionKey key)
        throws ServiceException
    {
        try
        {
            SocketChannel channel = (SocketChannel)key.channel();

            if (log.isDebugEnabled())
            {
                log.debug
                    ("handle() incoming connection from "+
                     channel.socket().getInetAddress());
            }

            final java.io.BufferedReader reader = new java.io.BufferedReader
                (NetUtils.channelToReader((ReadableByteChannel)channel));

            String request = reader.readLine();

            //if (request == null)
            //{
            //    log.debug("handle() received a null request... Returning.");
            //    return;
            //}

            if (log.isDebugEnabled())
                log.debug("handle() request is \n>"+request+"<");

            String[] ss = request.split(" ");

            if (ss.length < 3)
            {
                NetUtils.httpReply
                    (key,
                     400,
                     "Bad Request",
                     SERVER_NAME,
                     null,
                     "text/plain",
                     "Bad Request");
                return;
            }

            //log.debug("ss[0].toLowerCase() is >"+ss[0].toLowerCase()+"<");

            if ( ! ss[0].toLowerCase().equals("get"))
            {
                NetUtils.httpReply
                    (key,
                     403,
                     "only GET method is allowed",
                     SERVER_NAME,
                     null,
                     "text/plain",
                     "only GET method is allowed");
                return;
            }

            String target = ss[1];

            replyWithStatus(key, target);
        }
        catch (java.io.IOException ie)
        {
            throw new ServiceException
                ("Socket handling failed", ie);
        }
    }

    //
    // METHODS

    protected void replyWithStatus (SelectionKey key, String target)
    {
        org.jdom.Element rootElt = new org.jdom.Element(STATUS);

        //
        // add components to status
        
        if (target.equals("/"))
        {
            //log.debug("sending back status of all services");

            getContext().outputStatus(rootElt);
        }
        else
        {
            //log.debug("target is >"+target+"<");

            if (target.startsWith("/")) target = target.substring(1);

            //log.debug("target is >"+target+"<");

            Object o = getContext().lookup(target);

            if (o == null)
            {
                org.jdom.Element elt = new org.jdom.Element(NO_SERVICE);
                elt.addContent(target);

                rootElt.addContent(elt);
            }
            else if ( ! (o instanceof Service))
            {
                org.jdom.Element elt = new org.jdom.Element(PARAM);

                org.jdom.Element name = new org.jdom.Element(NAME);
                name.addContent(target);
                elt.addContent(name);

                org.jdom.Element value = new org.jdom.Element(VALUE);
                value.addContent(o.toString());
                elt.addContent(value);

                rootElt.addContent(elt);
            }
            else
            {
                rootElt.addContent(((Service)o).getStatus());
            }
        }

        //
        // output XML
        
        final org.jdom.output.XMLOutputter out = XmlUtils.getXMLOutputter();

        String content = out.outputString(rootElt);

        //log.debug("content is \n"+content);

        //
        // reply

        NetUtils.httpReply
            (key,
             200,
             "OK",
             SERVER_NAME,
             null,
             "text/xml",
             content);
    }

}
