/*
 * Copyright (c) 2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ReflectionUtils.java 2673 2006-05-26 21:08:46Z jmettraux $
 */

//
// BeanCoderUtils.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.util.beancoder;

import java.lang.reflect.Constructor;

import openwfe.org.Utils;


/**
 * Utility methods for the bean coding job.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author$
 * <br>$Id$ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class BeanCoderUtils
{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(BeanCoderUtils.class.getName());
    */

    //
    // CONSTANTS & co

    //
    // CONSTRUCTORS

    /*
     * Just making sure nobody will extend this utility class.
     */
    private BeanCoderUtils ()
    {
        super();
    }

    //
    // STATIC METHODS

    /**
     * Returns true if the instance is of a class that can be turned
     * into a primitive.
     */
    public static boolean isPrimitive (final Object instance)
    {
        final Class clazz = instance.getClass();

        if (clazz == String.class) return true;
        if (clazz == Integer.class) return true;
        if (clazz == Long.class) return true;
        if (clazz == Short.class) return true;
        if (clazz == Float.class) return true;
        if (clazz == Double.class) return true;
        if (clazz == Boolean.class) return true;
        if (clazz == Character.class) return true;
        if (clazz == Byte.class) return true;

        return false;
    }

    /** 
     * Given a primitive class (Long, Integer, Boolean, ...), builds
     * such a primitive by calling the constructor(String s) method
     * of that primitive.
     */
    public static Object newPrimitive
        (final Class primitiveClass, final String value)
    throws
        BeanCoderException
    {
        if (primitiveClass == Character.class)
            return new Character(value.charAt(0));

        try
        {
            final Constructor c = primitiveClass
                .getConstructor(new Class[] { String.class });

            return c.newInstance(new Object[] { value });
        }
        catch (final Throwable t)
        {
            throw new BeanCoderException
                ("failed to build primitive of class '"+primitiveClass+
                 "' from text '"+Utils.summarize(value)+"'", 
                 t);
        }
    }

}
