/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.embed.impl.engine;

import java.util.HashMap;
import openwfe.org.AbstractService;
import openwfe.org.ApplicationContext;
import openwfe.org.OwfeRunnable;
import openwfe.org.Service;
import openwfe.org.ServiceException;
import openwfe.org.embed.engine.EmbeddedParticipant;
import openwfe.org.embed.engine.Engine;
import openwfe.org.embed.impl.engine.EmbeddedParticipantMap;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.control.ControlSession;
import openwfe.org.engine.control.local.ControlSessionImpl;
import openwfe.org.engine.expool.ExpressionPool;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.map.XmlExpressionMap;
import openwfe.org.engine.impl.functions.XmlFunctionMap;
import openwfe.org.engine.impl.launch.SimpleXmlLauncher;
import openwfe.org.engine.launch.LaunchException;
import openwfe.org.engine.launch.Launcher;
import openwfe.org.engine.participants.Participant;
import openwfe.org.engine.participants.ParticipantMap;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.LaunchItem;
import openwfe.org.engine.workitem.XmlCoderLoader;
import org.apache.log4j.Logger;

public abstract class AbstractEngine
extends AbstractService
implements Engine {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$embed$impl$engine$AbstractEngine == null ? (class$openwfe$org$embed$impl$engine$AbstractEngine = AbstractEngine.class$("openwfe.org.embed.impl.engine.AbstractEngine")) : class$openwfe$org$embed$impl$engine$AbstractEngine).getName());
    public static final String DEFAULT_ENGINE_NAME = "embedded-engine";
    static /* synthetic */ Class class$openwfe$org$embed$impl$engine$AbstractEngine;

    public AbstractEngine() throws ServiceException {
        this(null);
    }

    public AbstractEngine(String string) throws ServiceException {
        if (string == null) {
            string = DEFAULT_ENGINE_NAME;
        }
        ApplicationContext applicationContext = new ApplicationContext();
        applicationContext.setApplicationName(string);
        this.init(string, applicationContext, new HashMap(0));
        SimpleXmlLauncher simpleXmlLauncher = new SimpleXmlLauncher();
        simpleXmlLauncher.init("launcher", applicationContext, new HashMap(0));
        applicationContext.add((Service)simpleXmlLauncher);
        EmbeddedParticipantMap embeddedParticipantMap = new EmbeddedParticipantMap();
        embeddedParticipantMap.init("participantMap", applicationContext, new HashMap(0));
        applicationContext.add((Service)embeddedParticipantMap);
        XmlExpressionMap xmlExpressionMap = new XmlExpressionMap();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("expressionMapFile", "resource:/expression-map.xml");
        xmlExpressionMap.init("expressionMap", applicationContext, hashMap);
        applicationContext.add((Service)xmlExpressionMap);
        XmlFunctionMap xmlFunctionMap = new XmlFunctionMap();
        HashMap<String, String> hashMap2 = new HashMap<String, String>(1);
        hashMap2.put("functionMapFile", "resource:/function-map.xml");
        xmlFunctionMap.init("functionMap", applicationContext, hashMap2);
        applicationContext.add((Service)xmlFunctionMap);
        XmlCoderLoader xmlCoderLoader = new XmlCoderLoader();
        HashMap<String, String> hashMap3 = new HashMap<String, String>(1);
        hashMap3.put("configurationFile", "resource:/coder-configuration.xml");
        xmlCoderLoader.init("workItemCoderLoader", applicationContext, hashMap3);
        applicationContext.add((Service)xmlCoderLoader);
    }

    public FlowExpressionId launch(LaunchItem launchItem, boolean bl) throws LaunchException {
        Launcher launcher = Definitions.getLauncher((ApplicationContext)this.getContext());
        return launcher.launch(launchItem, bl);
    }

    public FlowExpressionId launch(String string, boolean bl) throws LaunchException {
        LaunchItem launchItem = new LaunchItem();
        launchItem.setWorkflowDefinitionUrl(string);
        return this.launch(launchItem, bl);
    }

    public void registerParticipant(EmbeddedParticipant embeddedParticipant) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("registerParticipant() '" + embeddedParticipant.getRegex() + "'"));
        }
        embeddedParticipant.setEngine(this);
        ParticipantMap participantMap = Definitions.getParticipantMap((ApplicationContext)this.getContext());
        if (embeddedParticipant.getParams() == null) {
            embeddedParticipant.init(embeddedParticipant.getRegex(), new HashMap());
        }
        participantMap.add((Participant)embeddedParticipant);
    }

    public void reply(InFlowWorkItem inFlowWorkItem) throws ReplyException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("reply() to " + inFlowWorkItem.getLastExpressionId()));
        }
        this.getExpressionPool().reply(inFlowWorkItem.getLastExpressionId(), inFlowWorkItem);
    }

    public void setDaemon(boolean bl) {
        this.getExpressionPool().getScheduler().setDaemonIfIdle(bl);
    }

    public boolean isDaemon() {
        return this.getExpressionPool().getScheduler().isDaemonIfIdle();
    }

    public void stop() throws ServiceException {
        ((OwfeRunnable)this.getExpressionPool()).stop();
        super.stop();
    }

    public ControlSession getControlSession() {
        try {
            ControlSessionImpl controlSessionImpl = new ControlSessionImpl();
            String string = this.getName() + "_session_" + controlSessionImpl.toString();
            ((Service)controlSessionImpl).init(string, this.getContext(), new HashMap(0));
            return controlSessionImpl;
        }
        catch (Throwable throwable) {
            log.warn((Object)"getControlSession() failed to establish control session", throwable);
            return null;
        }
    }

    protected ExpressionPool getExpressionPool() {
        return Definitions.getExpressionPool((ApplicationContext)this.getContext());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

