/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: DbPersistedEngine.java 1947 2005-07-14 08:28:08Z jmettraux $
 */

//
// DbPersistedEngine.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.embed.impl.engine;

import openwfe.org.ServiceException;
import openwfe.org.sql.ds.AdHocDataSource;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.impl.expool.XmlExpressionStore;
import openwfe.org.xlob.engine.XlobExpressionStore;


/**
 * A persisted engine storing its data in an RDBMS (through OpenWFE xlob).
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: DbPersistedEngine.java 1947 2005-07-14 08:28:08Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class DbPersistedEngine

    extends PersistedEngine

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(DbPersistedEngine.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    //
    // CONSTRUCTORS

    /**
     * Builds an engine with a given sql connnection.
     */
    public DbPersistedEngine (final java.sql.Connection con)
        throws ServiceException
    {
        this(null, con, true);
    }

    /**
     * Builds an engine with a given sql connection and a given name.
     */
    public DbPersistedEngine 
        (final String engineName, 
         final java.sql.Connection con)
    throws 
        ServiceException
    {
        this(engineName, con, true);
    }

    /**
     * This constructor features a parameter for turning caching off (false), 
     * by default, caching is on.
     */
    public DbPersistedEngine 
        (final String engineName, 
         final java.sql.Connection con, 
         final boolean cached)
    throws 
        ServiceException
    {
        super(engineName, cached);

        //
        // data source

        final java.util.Map dsParams = new java.util.HashMap(1);

        dsParams.put(AdHocDataSource.P_CONNECTION, con);

        AdHocDataSource ds = new AdHocDataSource();
        
        ds.init(AdHocDataSource.P_DATA_SOURCE, getContext(), dsParams);

        getContext().add(ds);

        //
        // expression store

        setUpStore();

        //
        // expression pool

        // is initted in parent class PersistedEngine

    }

    /**
     * This constructor features a parameter for turning caching off (false), 
     * by default, caching is on.
     */
    public DbPersistedEngine 
        (final String engineName, 
         final javax.sql.DataSource datasource,
         final boolean cached)
    throws 
        ServiceException
    {
        super(engineName, cached);

        //
        // data source

        final java.util.Map dsParams = new java.util.HashMap(1);

        dsParams.put(AdHocDataSource.P_DATASOURCE, datasource);

        AdHocDataSource ds = new AdHocDataSource();
        
        ds.init(AdHocDataSource.P_DATA_SOURCE, getContext(), dsParams);

        getContext().add(ds);

        //
        // expression store

        setUpStore();

        //
        // expression pool

        // is initted in parent class PersistedEngine

    }

    private void setUpStore ()
        throws ServiceException
    {
        final java.util.Map esParams = new java.util.HashMap(0);

        XlobExpressionStore eStore = new XlobExpressionStore();

        eStore.init(Definitions.S_EXPRESSION_STORE, getContext(), esParams);

        getContext().add(eStore);
    }

    //
    // METHODS

    //
    // METHODS from Engine

    //
    // STATIC METHODS

}
