/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: InMemoryEngine.java 2105 2005-09-11 09:44:42Z jmettraux $
 */

//
// InMemoryEngine.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.embed.impl.engine;

import openwfe.org.ServiceException;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.expool.ExpressionPool;
import openwfe.org.engine.impl.expool.InMemoryExpressionPool;


/**
 * A transient embedded engine : everything is stored in memory, nothing
 * is persisted.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: InMemoryEngine.java 2105 2005-09-11 09:44:42Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class InMemoryEngine

    extends AbstractEngine

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(InMemoryEngine.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    //
    // CONSTRUCTORS

    /**
     * Builds an InMemoryEngine with the default engine name.
     */
    public InMemoryEngine ()
        throws ServiceException
    {
        this(null);
    }

    /**
     * Builds an InMemoryEngine with a given engine name.
     */
    public InMemoryEngine (final String engineName)
        throws ServiceException
    {
        super(engineName);

        //
        // expression pool

        final java.util.Map epParams = new java.util.HashMap(1);
        epParams.put(ExpressionPool.P_RESCHEDULE, "false");

        InMemoryExpressionPool ePool = new InMemoryExpressionPool();

        ePool.init(Definitions.S_EXPRESSION_POOL, getContext(), epParams);

        getContext().add(ePool);
    }

    //
    // METHODS

    //
    // METHODS from Engine

    //
    // STATIC METHODS

}
