/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: TestWorklist.java 2431 2006-03-15 08:56:32Z jmettraux $
 */

//
// TestEngine.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.embed.tst;

import openwfe.org.engine.control.ControlSession;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.LaunchItem;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.AttributeUtils;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.embed.engine.Engine;
import openwfe.org.embed.worklist.Worklist;
import openwfe.org.embed.impl.engine.InMemoryEngine;
import openwfe.org.embed.impl.engine.AbstractEmbeddedParticipant;
import openwfe.org.embed.impl.worklist.InMemoryWorklist;


/**
 * Testing the embedded worklist
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: TestWorklist.java 2431 2006-03-15 08:56:32Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class TestWorklist
{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(TestEngine.class.getName());
    */

    public static void main (String[] args)
        throws Exception
    {
        //
        // prepare engine

        Engine engine = new InMemoryEngine();

        // prepare worklists

        InMemoryWorklist wla = new InMemoryWorklist("a");
        InMemoryWorklist wlb = new InMemoryWorklist("b");
        InMemoryWorklist wlc = new InMemoryWorklist("c");

        // register participants

        engine.registerParticipant(wla);
        engine.registerParticipant(wlb);
        engine.registerParticipant(wlc);

        //
        // launch flow

        LaunchItem li = new LaunchItem();
        li.setWorkflowDefinitionUrl("field:__definition__");

        String flowDef = 
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"+
            "<process-definition name=\"test\" revision=\"0.0\">\n"+
            "   <sequence>\n"+
            "      <participant ref=\"a\" />\n"+
            "      <participant ref=\"b\" />\n"+
            "      <participant ref=\"c\" />\n"+
            "   </sequence>\n"+
            "</process-definition>";

        li.getAttributes().puts("__definition__", flowDef);

        engine.launch(li, false);

        //
        // play with the flow

        System.out.println
            ("exp count : "+
             engine.getControlSession().listExpressions().size());

        System.out.println("wla.countWorkItems() : "+wla.countWorkItems());
        System.out.println("wlb.countWorkItems() : "+wlb.countWorkItems());
        System.out.println("wlc.countWorkItems() : "+wlc.countWorkItems());

        java.util.Iterator it = wla.iterator();

        InFlowWorkItem wi = (InFlowWorkItem)it.next();
        System.out.println("\n wi "+wi+"  /  "+wi.getLastExpressionId());

        wla.forward(wi);
        System.out.println("\n ~~ forwarded workitem\n");

        //System.out.println
        //    ("exp count : "+
        //     engine.getControlSession().listExpressions().size());

        System.out.println("wla.countWorkItems() : "+wla.countWorkItems());
        System.out.println("wlb.countWorkItems() : "+wlb.countWorkItems());
        System.out.println("wlc.countWorkItems() : "+wlc.countWorkItems());

        it = wlb.iterator();

        wi = (InFlowWorkItem)it.next();
        System.out.println("\n wi "+wi+"  /  "+wi.getLastExpressionId());

        wlb.forward(wi);
        System.out.println("\n ~~ forwarded workitem\n");

        //System.out.println
        //    ("exp count : "+
        //     engine.getControlSession().listExpressions().size());

        System.out.println("wla.countWorkItems() : "+wla.countWorkItems());
        System.out.println("wlb.countWorkItems() : "+wlb.countWorkItems());
        System.out.println("wlc.countWorkItems() : "+wlc.countWorkItems());

        it = wlc.iterator();

        wi = (InFlowWorkItem)it.next();
        System.out.println("\n wi "+wi+"  /  "+wi.getLastExpressionId());

        wlc.forward(wi);
        System.out.println("\n ~~ forwarded workitem\n");

        //System.out.println
        //    ("exp count : "+
        //     engine.getControlSession().listExpressions().size());

        //displayExpressions(engine);

        System.out.println("wla.countWorkItems() : "+wla.countWorkItems());
        System.out.println("wlb.countWorkItems() : "+wlb.countWorkItems());
        System.out.println("wlc.countWorkItems() : "+wlc.countWorkItems());
    }

    /*
    private static void displayExpressions (Engine engine)
        throws Exception
    {
        System.out.println();

        java.util.Iterator it = 
            engine.getControlSession().listExpressions().iterator();
        while (it.hasNext())
        {
            FlowExpression fe = (FlowExpression)it.next();

            System.out.println("    - "+fe.getId());
        }

        System.out.println();
    }
    */

}
