/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.embed.impl.worklist;

import java.util.Iterator;
import openwfe.org.ApplicationContext;
import openwfe.org.embed.engine.Engine;
import openwfe.org.embed.worklist.Worklist;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.participants.AbstractParticipant;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.worklist.WorkListException;
import openwfe.org.worklist.store.WorkItemStorage;
import org.apache.log4j.Logger;

public abstract class AbstractWorklist
extends AbstractParticipant
implements Worklist {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$embed$impl$worklist$AbstractWorklist == null ? (class$openwfe$org$embed$impl$worklist$AbstractWorklist = AbstractWorklist.class$("openwfe.org.embed.impl.worklist.AbstractWorklist")) : class$openwfe$org$embed$impl$worklist$AbstractWorklist).getName());
    private Engine engine = null;
    private String listName = null;
    static /* synthetic */ Class class$openwfe$org$embed$impl$worklist$AbstractWorklist;

    public AbstractWorklist(String string) {
        this(string, string);
    }

    public AbstractWorklist(String string, String string2) {
        this.setRegex(string);
        this.listName = string2;
    }

    public String getListName() {
        return this.listName;
    }

    public abstract WorkItemStorage getStorage() throws WorkListException;

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public void replyToEngine(InFlowWorkItem inFlowWorkItem) throws ReplyException {
        this.engine.reply(inFlowWorkItem);
    }

    public void consume(WorkItem workItem) throws Exception {
        this.save((InFlowWorkItem)workItem);
    }

    public Object dispatch(ApplicationContext applicationContext, WorkItem workItem) throws DispatchingException {
        try {
            this.consume(workItem);
            return null;
        }
        catch (Throwable throwable) {
            log.debug((Object)"embedded participant failure", throwable);
            throw new DispatchingException("embedded participant failure", throwable);
        }
    }

    public int countWorkItems() throws WorkListException {
        return this.getStorage().countWorkItems(this.listName);
    }

    public Iterator iterator() throws WorkListException {
        return this.getStorage().listWorkItems(this.listName, -1).iterator();
    }

    public InFlowWorkItem get(FlowExpressionId flowExpressionId) throws WorkListException {
        return this.getStorage().retrieveWorkItem(this.listName, flowExpressionId);
    }

    public void save(InFlowWorkItem inFlowWorkItem) throws WorkListException {
        this.getStorage().storeWorkItem(this.listName, (InFlowWorkItem)inFlowWorkItem.clone());
    }

    public void forward(InFlowWorkItem inFlowWorkItem) throws WorkListException {
        this.getStorage().removeWorkItem(this.listName, inFlowWorkItem.getLastExpressionId());
        try {
            this.replyToEngine(inFlowWorkItem);
        }
        catch (ReplyException replyException) {
            throw new WorkListException("Forward (proceed) failure", (Throwable)replyException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

