/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: Engine.java 2535 2006-05-02 14:46:42Z jmettraux $
 */

//
// Engine.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.embed.engine;

import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import openwfe.org.engine.launch.LaunchException;
import openwfe.org.engine.control.ControlSession;
import openwfe.org.engine.workitem.LaunchItem;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.FlowExpressionId;


/**
 * The interface of an embedded OpenWFE engine
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: Engine.java 2535 2006-05-02 14:46:42Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public interface Engine
{
    
    /**
     * Given a launch item, launches a flow in the embedded engine.
     *
     * @param async when this param is set to false, the launch call will only
     * return when the flow has been completely launched. With async set to
     * true, the method call will return immediately with the launch resuming
     * in another tread.
     */
    public FlowExpressionId launch (LaunchItem li, boolean async)
        throws LaunchException;

    /**
     * Given the URL of a process definition, launches an instance of
     * it in the embedded engine.
     *
     * @param async when this param is set to false, the launch call will only
     * return when the flow has been completely launched. With async set to
     * true, the method call will return immediately with the launch resuming
     * in another tread.
     */
    public FlowExpressionId launch (String flowUrl, boolean async)
        throws LaunchException;

    /**
     * Registers a participant in the participant map of the embedded engine.
     */
    public void registerParticipant (EmbeddedParticipant p);

    /**
     * When a participant has finished working with a workitem, it uses this
     * method to give it back to the engine.
     */
    public void reply (InFlowWorkItem wi)
        throws ReplyException;

    /**
     * Returns the context where the embedded engine components are located.
     */
    public ApplicationContext getContext ();

    /**
     * Returns the name of this embedded engine.
     */
    public String getName ();

    /**
     * If daemon is set to true (the default value), the embedded engine will
     * allow the VM to exit once there are no more pending jobs in its 
     * scheduler.
     */
    public void setDaemon (boolean b);

    /**
     * @see #setDaemon
     */
    public boolean isDaemon ();

    /**
     * Stops the engine and makes sure the underlying resources are properly
     * disposed of.
     */
    public void stop ()
        throws ServiceException;

    /**
     * Returns a control session on this engine.
     */
    public ControlSession getControlSession ();

}
