/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: InMemoryWorklist.java 2494 2006-04-15 21:15:08Z jmettraux $
 */

//
// InMemoryWorklist.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.embed.impl.worklist;

import openwfe.org.Service;
import openwfe.org.ServiceException;
import openwfe.org.worklist.WorkListException;
import openwfe.org.worklist.store.WorkItemStorage;
import openwfe.org.worklist.impl.store.InMemoryWorkItemStorage;


/**
 * A volatile worklist : workitems are stored in memory (and are thus lost when
 * the JVM is shut down.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: InMemoryWorklist.java 2494 2006-04-15 21:15:08Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class InMemoryWorklist

    extends AbstractWorklist

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(InMemoryWorklist.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    private WorkItemStorage storage = null;

    //
    // CONSTRUCTORS

    /**
     * Builds a worklist for a participant name that is not a regular expression
     * (thus, the participant name and the list name will be the same).
     */
    public InMemoryWorklist 
        (final String participantName)
    {
        this(participantName, participantName);
    }

    /**
     * Builds a worklist where the participant name is a regular expression and
     * thus cannot be employed as a list name : the list name is given as
     * a parameter of this constructor.
     */
    public InMemoryWorklist 
        (final String participantRegex, final String listName)
    {
        super(participantRegex, listName);

        //
        // ready storage

        this.storage = new InMemoryWorkItemStorage();
        try
        {
            ((Service)this.storage)
                .init(listName, null, new java.util.HashMap(0));
        }
        catch (final ServiceException e)
        {
            log.warn
                ("() failed to init underlying InMemoryWorkItemStorage", e);
        }
    }

    //
    // METHODS

    //
    // METHODS from AbstractWorklist

    /**
     * Returns the storage attached to this embedded worklist. 
     * Will throw a WorkListException if no storage could be found.
     */
    public WorkItemStorage getStorage ()
        throws WorkListException
    {
        return this.storage;
    }


    //
    // STATIC METHODS

}
