/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: TestDbEngine.java 2431 2006-03-15 08:56:32Z jmettraux $
 */

//
// TestEngine.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.embed.tst;

import openwfe.org.engine.Definitions;
import openwfe.org.engine.control.ControlSession;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.LaunchItem;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.impl.history.TextHistory;
import openwfe.org.embed.engine.Engine;
import openwfe.org.embed.impl.engine.DbPersistedEngine;
import openwfe.org.embed.impl.engine.AbstractEmbeddedParticipant;


/**
 * Testing the embedded engine
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: TestDbEngine.java 2431 2006-03-15 08:56:32Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class TestDbEngine
{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(TestEngine.class.getName());
    */

    public static void main (String[] args)
        throws Exception
    {
        //
        // prepare engine

        /*

        //
        // mysql

        Class.forName("com.mysql.jdbc.Driver").newInstance();

        java.sql.Connection con = java.sql.DriverManager.getConnection
            ("jdbc:mysql://localhost/xlob?user=xlob&password=xlob");
        */

        //
        // postgresql

        Class.forName("org.postgresql.Driver").newInstance();

        java.sql.Connection con = java.sql.DriverManager.getConnection
            ("jdbc:postgresql:xlob", "xlob", "xlob");


        Engine engine = new DbPersistedEngine(null, con, false);
            //
            // engineName : null (will take default name)
            // connection : con
            // cached : false (db will be read each time)
            //
            //
            // you can also pass a javax.sql.DataSource instance
            // instead of the java.sql.Connection instance.

        engine.setDaemon(true);
            //
            // allows the VM to exit when there are no more jobs scheduled

        final java.util.Map hParams = new java.util.HashMap();
        hParams.put(TextHistory.P_FILE_NAME, "history.log");

        TextHistory history = new TextHistory();
        history.init(Definitions.S_HISTORY, engine.getContext(), hParams);

        engine.getContext().add(history);

        /*
         * The inMemoryEngine only stores its rundata in RAM, 
         * the FsPersistedEngine stores its rundata in a temp folder.
         *
         * From one run to the other, the DbPersistedEngine will be able
         * to retrieve and reuse its rundate (if it has been deleted).
         * 
         */

        // register participants

        engine.registerParticipant
            (new AbstractEmbeddedParticipant ("a") 
             {
                 public void consume (WorkItem wi)
                     throws Exception
                 {
                     System.out.println("~~~ a");

                     wi.getAttributes().puts("value", "CHF 10.-");

                     replyToEngine((InFlowWorkItem)wi);
                 }
             });

        /*
         * This is an easy (and very swinggy) way of adding participants
         * to an engine.
         *
         * Please note the presence at the end of 'consume' of the method
         * 'replyToEngine()' which hands back the [modified] workitem
         * to the engine.
         */

        engine.registerParticipant
            (new AbstractEmbeddedParticipant ("b") 
             {
                 public void consume (WorkItem wi)
                     throws Exception
                 {
                     System.out.println("~~~ b");

                     System.out.println("    value : "+wi.getAttributes().sget("value"));

                     replyToEngine((InFlowWorkItem)wi);
                 }
             });

        engine.registerParticipant
            (new AbstractEmbeddedParticipant ("x") 
             {
                 public void consume (WorkItem wi)
                     throws Exception
                 {
                     System.out.println("~~~ x");

                     System.exit(-1);
                     //replyToEngine((InFlowWorkItem)wi);
                 }
             });

        //
        // launch flow

        LaunchItem li = new LaunchItem();
        li.setWorkflowDefinitionUrl("field:__definition__");

        /*
        String flowDef = 
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"+
            "<process-definition name=\"test\" revision=\"0.0\">\n"+
            "   <sequence>\n"+
            "      <participant ref=\"a\" />\n"+
            "      <participant ref=\"b\" />\n"+
            "   </sequence>\n"+
            "</process-definition>";
        */

        String flowDef = 
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"+
            "<process-definition name=\"test3\" revision=\"0.0\">\n"+
            "   <sequence>\n"+
            "      <participant ref=\"a\" />\n"+
            "      <subprocess ref=\"sub\"  />"+
            "      <participant ref=\"b\" />\n"+
            "   </sequence>\n"+			
            "<process-definition name=\"sub\">\n"+
            "   <sequence>"+
            "      <participant ref=\"x\" />\n"+
            "   </sequence>"+
            "</process-definition>" +
            "</process-definition>";

        li.getAttributes().puts("__definition__", flowDef);

        /*
         * This launch item workflowDefinitionUrl is pointing to
         * 'field:__definition__' : the flow definition will not be
         * fetch from a URL but directly from a launch item field,
         * here '__definition__'.
         */

        engine.launch(li, true);

        //
        // testing the control stuff

        /*
        ControlSession cs = engine.getControlSession();

        System.out.println("cs is "+cs);

        java.util.Iterator it = cs.listExpressions().iterator();
        while (it.hasNext())
            System.out.println(it.next());
        */
    }

}
