/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.embed.impl.engine;

import java.util.HashMap;
import openwfe.org.AbstractService;
import openwfe.org.ApplicationContext;
import openwfe.org.OwfeRunnable;
import openwfe.org.Service;
import openwfe.org.ServiceException;
import openwfe.org.embed.engine.EmbeddedParticipant;
import openwfe.org.embed.engine.Engine;
import openwfe.org.embed.impl.engine.EmbeddedParticipantMap;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.control.ControlSession;
import openwfe.org.engine.control.local.ControlSessionImpl;
import openwfe.org.engine.expool.ExpressionPool;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.map.XmlExpressionMap;
import openwfe.org.engine.impl.functions.XmlFunctionMap;
import openwfe.org.engine.impl.launch.SimpleXmlLauncher;
import openwfe.org.engine.launch.LaunchException;
import openwfe.org.engine.launch.Launcher;
import openwfe.org.engine.participants.Participant;
import openwfe.org.engine.participants.ParticipantMap;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.LaunchItem;
import openwfe.org.engine.workitem.XmlCoderLoader;
import org.apache.log4j.Logger;

public abstract class AbstractEngine
extends AbstractService
implements Engine {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$embed$impl$engine$AbstractEngine == null ? (class$openwfe$org$embed$impl$engine$AbstractEngine = AbstractEngine.class$("openwfe.org.embed.impl.engine.AbstractEngine")) : class$openwfe$org$embed$impl$engine$AbstractEngine).getName());
    public static final String DEFAULT_ENGINE_NAME = "embedded-engine";
    private static final String S_CONSUMER = "consumer";
    static /* synthetic */ Class class$openwfe$org$embed$impl$engine$AbstractEngine;

    public AbstractEngine() throws ServiceException {
        this(null);
    }

    public AbstractEngine(String engineName) throws ServiceException {
        if (engineName == null) {
            engineName = DEFAULT_ENGINE_NAME;
        }
        ApplicationContext ac = new ApplicationContext();
        ac.setApplicationName(engineName);
        this.init(engineName, ac, new HashMap(0));
        SimpleXmlLauncher launcher = new SimpleXmlLauncher();
        launcher.init("launcher", ac, new HashMap(0));
        ac.add((Service)launcher);
        EmbeddedParticipantMap pMap = new EmbeddedParticipantMap();
        pMap.init("participantMap", ac, new HashMap(0));
        ac.add((Service)pMap);
        XmlExpressionMap eMap = new XmlExpressionMap();
        HashMap<String, String> eMapParams = new HashMap<String, String>(1);
        eMapParams.put("expressionMapFile", "resource:/expression-map.xml");
        eMap.init("expressionMap", ac, eMapParams);
        ac.add((Service)eMap);
        XmlFunctionMap fMap = new XmlFunctionMap();
        HashMap<String, String> fMapParams = new HashMap<String, String>(1);
        fMapParams.put("functionMapFile", "resource:/function-map.xml");
        fMap.init("functionMap", ac, fMapParams);
        ac.add((Service)fMap);
        XmlCoderLoader coderLoader = new XmlCoderLoader();
        HashMap<String, String> clParams = new HashMap<String, String>(1);
        clParams.put("configurationFile", "resource:/coder-configuration.xml");
        coderLoader.init("workItemCoderLoader", ac, clParams);
        ac.add((Service)coderLoader);
    }

    public FlowExpressionId launch(LaunchItem li, boolean async) throws LaunchException {
        Launcher l = Definitions.getLauncher((ApplicationContext)this.getContext());
        return l.launch(li, async);
    }

    public FlowExpressionId launch(String flowUrl, boolean async) throws LaunchException {
        LaunchItem li = new LaunchItem();
        li.setWorkflowDefinitionUrl(flowUrl);
        return this.launch(li, async);
    }

    public void registerParticipant(EmbeddedParticipant p) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("registerParticipant() '" + p.getRegex() + "'"));
        }
        p.setEngine(this);
        ParticipantMap pm = Definitions.getParticipantMap((ApplicationContext)this.getContext());
        p.init(p.getRegex(), new HashMap());
        pm.add((Participant)p);
    }

    public void reply(InFlowWorkItem wi) throws ReplyException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("reply() to " + wi.getLastExpressionId()));
        }
        this.getExpressionPool().reply(wi.getLastExpressionId(), wi);
    }

    public void setDaemon(boolean b) {
        this.getExpressionPool().getScheduler().setDaemonIfIdle(b);
    }

    public boolean isDaemon() {
        return this.getExpressionPool().getScheduler().isDaemonIfIdle();
    }

    public void stop() throws ServiceException {
        ((OwfeRunnable)this.getExpressionPool()).stop();
        super.stop();
    }

    public ControlSession getControlSession() {
        try {
            ControlSessionImpl cs = new ControlSessionImpl();
            String sessionServiceName = this.getName() + "_session_" + cs.toString();
            ((Service)cs).init(sessionServiceName, this.getContext(), new HashMap(0));
            return cs;
        }
        catch (Throwable t) {
            log.warn((Object)"getControlSession() failed to establish control session", t);
            return null;
        }
    }

    protected ExpressionPool getExpressionPool() {
        return Definitions.getExpressionPool((ApplicationContext)this.getContext());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

