/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.embed.impl.worklist;

import java.util.Iterator;
import openwfe.org.ApplicationContext;
import openwfe.org.embed.engine.Engine;
import openwfe.org.embed.worklist.Worklist;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.participants.AbstractParticipant;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.worklist.WorkListException;
import openwfe.org.worklist.store.WorkItemStorage;
import org.apache.log4j.Logger;

public abstract class AbstractWorklist
extends AbstractParticipant
implements Worklist {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$embed$impl$worklist$AbstractWorklist == null ? (class$openwfe$org$embed$impl$worklist$AbstractWorklist = AbstractWorklist.class$("openwfe.org.embed.impl.worklist.AbstractWorklist")) : class$openwfe$org$embed$impl$worklist$AbstractWorklist).getName());
    private Engine engine = null;
    private String listName = null;
    static /* synthetic */ Class class$openwfe$org$embed$impl$worklist$AbstractWorklist;

    public AbstractWorklist(String participantName) {
        this(participantName, participantName);
    }

    public AbstractWorklist(String participantRegex, String listName) {
        this.setRegex(participantRegex);
        this.listName = listName;
    }

    public String getListName() {
        return this.listName;
    }

    public abstract WorkItemStorage getStorage() throws WorkListException;

    public void setEngine(Engine e) {
        this.engine = e;
    }

    public void replyToEngine(InFlowWorkItem wi) throws ReplyException {
        this.engine.reply(wi);
    }

    public void consume(WorkItem wi) throws Exception {
        this.save((InFlowWorkItem)wi);
    }

    public Object dispatch(ApplicationContext context, WorkItem wi) throws DispatchingException {
        try {
            this.consume(wi);
            return null;
        }
        catch (Throwable t) {
            log.debug((Object)"embedded participant failure", t);
            throw new DispatchingException("embedded participant failure", t);
        }
    }

    public int countWorkItems() throws WorkListException {
        return this.getStorage().countWorkItems(this.listName);
    }

    public Iterator iterator() throws WorkListException {
        return this.getStorage().listWorkItems(this.listName, -1).iterator();
    }

    public InFlowWorkItem get(FlowExpressionId fei) throws WorkListException {
        return this.getStorage().retrieveWorkItem(this.listName, fei);
    }

    public void save(InFlowWorkItem wi) throws WorkListException {
        this.getStorage().storeWorkItem(this.listName, (InFlowWorkItem)wi.clone());
    }

    public void forward(InFlowWorkItem wi) throws WorkListException {
        this.getStorage().removeWorkItem(this.listName, wi.getLastExpressionId());
        try {
            this.replyToEngine(wi);
        }
        catch (ReplyException e) {
            throw new WorkListException("Forward (proceed) failure", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

