/*
 * Copyright (c) 2004-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: EngineTester.java 2714 2006-06-01 14:50:21Z jmettraux $
 */

//
// EngineTester.java.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.embed;

import openwfe.org.engine.Definitions;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.LaunchItem;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.impl.history.TextHistory;
import openwfe.org.embed.engine.Engine;
import openwfe.org.embed.impl.engine.InMemoryEngine;
import openwfe.org.embed.impl.engine.AbstractEmbeddedParticipant;


/**
 * Testing the embedded engine
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: EngineTester.java 2714 2006-06-01 14:50:21Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class EngineTester
{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(EngineTester.class.getName());

    private final static String F_INPUT = "__input__";

    //
    // MAIN

    public static void main (String[] args)
    {
        try
        {

            //
            // prepare engine

            Engine engine = new InMemoryEngine("eng-tester");

            engine.setDaemon(true);
                //
                // allows the VM to exit when there are no more jobs scheduled

            // add history service

            final java.util.Map hParams = new java.util.HashMap();
            hParams.put(TextHistory.P_FILE_NAME, "history.log");

            TextHistory history = new TextHistory();
            history.init(Definitions.S_HISTORY, engine.getContext(), hParams);

            engine.getContext().add(history);

            // register participants

            engine.registerParticipant
                (new AbstractEmbeddedParticipant(".*")
                 {
                     //
                     // this is a catch all participant, whatever the 
                     // participant name...
                     //

                     public void consume (WorkItem wi)
                         throws Exception
                     {
                         //System.out.print(this.getRegex()+" ");

                         System.out.print
                             (((InFlowWorkItem)wi).getParticipantName()+" ");

                         if (wi.getAttributes().hasKey(F_INPUT))
                         {
                             System.out.print
                                 (wi.getAttributes().sget(F_INPUT)+" ");
                         }

                         replyToEngine((InFlowWorkItem)wi);
                     }
                 });

            //
            // read flow from stdin

            StringBuffer sb = new StringBuffer();

            java.io.BufferedReader br = new java.io.BufferedReader
                (new java.io.InputStreamReader(System.in));

            while (true)
            {
                String line = br.readLine();

                if (line == null) break;

                sb.append(line);
                sb.append("\n");
            }

            //
            // launch flow

            LaunchItem li = new LaunchItem();
            li.setWorkflowDefinitionUrl("field:__def__");

            li.getAttributes().puts("__def__", sb.toString());

            engine.launch(li, true);
        }
        catch (final Throwable t)
        {
            log.warn("problem...", t);
        }
    }

}
