/*
 * Copyright (c) 2004-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: AbstractEmbeddedParticipant.java 2714 2006-06-01 14:50:21Z jmettraux $
 */

//
// EmbeddedParticipant.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.embed.impl.engine;

import openwfe.org.ApplicationContext;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.participants.AbstractParticipant;
import openwfe.org.embed.engine.Engine;
import openwfe.org.embed.engine.EmbeddedParticipant;


/**
 * An abstract class to be extended (and fully implemented) by embedded 
 * participant.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: AbstractEmbeddedParticipant.java 2714 2006-06-01 14:50:21Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class AbstractEmbeddedParticipant

    extends AbstractParticipant

    implements EmbeddedParticipant

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(EmbeddedParticipant.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    private Engine engine = null;

    //
    // CONSTRUCTORS

    public AbstractEmbeddedParticipant ()
    {
        super();
    }

    public AbstractEmbeddedParticipant (final String name)
    {
        super();

        this.setRegex(name);
    }

    //
    // METHODS

    /**
     * This method is used by the registerParticipant() method of the embedded
     * engine (so that the participant knows which is its engine).
     */
    public void setEngine (final Engine e)
    {
        this.engine = e;
    }

    /**
     * A shortcut method, allowing the embedded participants full implementation
     * to return their workitem to the emitting engine after consumption.
     */
    public void replyToEngine (final InFlowWorkItem wi)
        throws ReplyException
    {
        this.engine.reply(wi);
    }

    //
    // METHODS from Participant

    /**
     * This is a method from the engine/Participant class : a regular
     * OpenWFE engines doesn't know about embedded participants, but it
     * knows about [plain] participants.
     * This method wraps the consume() call and thus bridges the regular
     * participant that the classical engine manipulates to the 
     * embedded participant.
     */
    public Object dispatch 
        (final ApplicationContext context, final WorkItem wi)
    throws 
        DispatchingException
    {
        //
        // Making sure to copy the workitem :
        // else problems may arise (the engine modifiying the workitem
        // while the participant holds it).
        // We're in the same JVM after all...
        //

        try
        {
            final InFlowWorkItem workitem = (InFlowWorkItem)wi;

            consume((InFlowWorkItem)workitem.clone());
            return null;
        }
        catch (final Throwable t)
        {
            log.debug("dispatch() failure", t);

            throw new DispatchingException("dispatch() failure", t);
        }
    }

    //
    // ABSTRACT METHODS

    //
    // STATIC METHODS

}
