/*
 * Copyright (c) 2004-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: FsPersistedEngine.java 2714 2006-06-01 14:50:21Z jmettraux $
 */

//
// FsPersistedEngine.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.embed.impl.engine;

import openwfe.org.ServiceException;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.impl.expool.XmlExpressionStore;


/**
 * A persisted engine storing its data in [the temp section of] the filesystem.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: FsPersistedEngine.java 2714 2006-06-01 14:50:21Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class FsPersistedEngine

    extends PersistedEngine

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(FsPersistedEngine.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    //
    // CONSTRUCTORS

    /**
     * Instantiates a fs persisted engine with default name "" and
     * persisting to default system temp dir (/tmp on unix), caching turned on.
     */
    public FsPersistedEngine ()
        throws ServiceException
    {
        this(null, null, true);
    }

    /**
     * Instantiates a fs persisted engine with the given name and
     * persisting to default system temp dir (/tmp on unix), caching turned on.
     */
    public FsPersistedEngine (final String engineName)
        throws ServiceException
    {
        this(engineName, null, true);
    }

    /**
     * Instantiates a fs persisted engine with the given name and
     * persisting to a given workDirectory (+ "/expstore").
     */
    public FsPersistedEngine 
        (final String engineName, String workDirectory, final boolean cached)
    throws 
        ServiceException
    {
        super(engineName, cached);

        //
        // setting application context directory

        if (workDirectory == null)
        {
            final String tmpDir = System.getProperty("java.io.tmpdir");

            final java.io.File d = new java.io.File
                (tmpDir + java.io.File.separator + getName());

            d.mkdirs();

            workDirectory = d.getPath();
        }

        getContext().setApplicationDirectory(workDirectory);

        if (log.isDebugEnabled())
            log.debug("() workDirectory is "+workDirectory);

        //
        // expression store

        final String workDir = 
            workDirectory + java.io.File.separator + "expstore";

        final java.util.Map esParams = new java.util.HashMap(1);

        esParams.put(XmlExpressionStore.P_WORK_DIRECTORY, workDir);

        XmlExpressionStore eStore = new XmlExpressionStore();

        eStore.init(Definitions.S_EXPRESSION_STORE, getContext(), esParams);

        getContext().add(eStore);

        //
        // expression pool

        // is initted in parent class PersistedEngine

    }

    //
    // METHODS

    //
    // METHODS from Engine

    //
    // STATIC METHODS

}
