//
// TestCase.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine._test;

import junit.framework.Assert;

import openwfe.org.xml.XmlCoder;
import openwfe.org.engine.expressions.*;
import openwfe.org.engine.expressions.sync.*;


/**
 * The test cases for the package
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2005-05-17 18:41:07 +0200 (Tue, 17 May 2005) $
 * <br>$Id: ExpressionCase.java 1882 2005-05-17 16:41:07Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public class ExpressionCase

    extends junit.framework.TestCase

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(ExpressionCase.class.getName());

    //
    // FIELDS

    //
    // CONSTRUCTORS

    public ExpressionCase (String name)
    {
        super(name);
    }

    //
    // METHODS

    public void setUp ()
    {
    }

    public void tearDown ()
    {
    }

    //
    // TEST METHODS

    /**
     * Fighting against bug #961170
     *
     * tests wether the sync expression is correctly SWAPPED with its
     * concurrence expression
     */
    public void testConcurrenceSwapping ()
        throws Exception
    {
        ConcurrenceExpression ce = new ConcurrenceExpression();
        //ce.setSyncExpression(new LastMergeSyncExpression());
        ce.setSyncExpression(new GenericSyncExpression());

        Assert.assertTrue
            ("SyncExpression got set", 
             ce.getSyncExpression() != null);

        XmlCoder.save("./tst/concurrence.xml", ce);
        log.debug("saved expression");

        ce = null;

        ce = (ConcurrenceExpression)XmlCoder.load("./tst/concurrence.xml");
        log.debug("loaded expression");

        Assert.assertTrue
            ("SyncExpression came back from swap too", 
             ce.getSyncExpression() != null);
    }

}
