/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: LocalDispatcher.java 1882 2005-05-17 16:41:07Z jmettraux $
 */

//
// LocalDispatcher.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.dispatch;

import openwfe.org.OpenWfeException;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import openwfe.org.time.Time;
import openwfe.org.engine.listen.WorkItemConsumer;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.InFlowWorkItem;


/**
 * A dispatcher directly linked to a local consumer, no loop outside of the 
 * application (engine, worklist, or whatever)
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2005-05-17 18:41:07 +0200 (Tue, 17 May 2005) $
 * <br>$Id: LocalDispatcher.java 1882 2005-05-17 16:41:07Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public class LocalDispatcher

    implements WorkItemDispatcher

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(LocalDispatcher.class.getName());

    //
    // CONSTANTS (definitions)

    /**
     * Use this parameter ('consumer') to indicate where the workitem
     * should get dispatched directly (locally)
     */
    public final static String P_CONSUMER
        = "consumer";

    //
    // FIELDS

    protected String name = null;
    protected ApplicationContext applicationContext = null;
    protected java.util.Map params = null;

    protected String consumerName = null;

    //
    // CONSTRUCTORS

    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {
        this.name = serviceName;
        this.applicationContext = context;
        this.params = serviceParams;

        this.consumerName = (String)this.params.get(P_CONSUMER);
            // consumer resolution is done at dispatch time

        if (this.consumerName == null)
        {
            throw new ServiceException
                ("Parameter '"+P_CONSUMER+
                 "' is required for setting up service "+this.name);
        }
    }

    //
    // METHODS

    public Object dispatch (WorkItem wi) 
        throws DispatchingException
    {
        //
        // set dispatch time

        if (wi instanceof InFlowWorkItem)
        {
            InFlowWorkItem ifwi = (InFlowWorkItem)wi;

            ifwi = (InFlowWorkItem)ifwi.clone();
            ifwi.setDispatchTime(Time.toIsoDate());

            wi = ifwi;

            //log.debug
            //    ("dispatch() participantName >"+
            //     ifwi.getParticipantName()+"<");
        }

        //
        // lookup consumer

        final WorkItemConsumer consumer = 
            (WorkItemConsumer)this.applicationContext.lookup(this.consumerName);

        //
        // feed him with workitem
        
        try
        {
            return consumer.use(wi);
        }
        catch (OpenWfeException owe)
        {
            throw new DispatchingException
                ("local dispatching to consumer '"+this.consumerName+
                 "' failed", owe);
        }
    }

    public void stop ()
        throws ServiceException
    {
        // nothing to do
    }

    public String getName ()
    {
        return this.name;
    }

    //
    // STATUS

    public org.jdom.Element getStatus ()
    {
        return new org.jdom.Element(getName());
    }

}
