/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: DefinedExpression.java 2089 2005-09-01 17:01:19Z jmettraux $
 */

//
// DefinedExpression.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.expressions;

import openwfe.org.engine.workitem.InFlowWorkItem;


/**
 * An expression that returns 'true' if a given field or variable 
 * is defined.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2005-09-01 19:01:19 +0200 (Thu, 01 Sep 2005) $
 * <br>$Id: DefinedExpression.java 2089 2005-09-01 17:01:19Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class DefinedExpression

    extends ZeroChildExpression

    implements BooleanExpression

{

    //
    // CONSTANTS

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    public void apply (InFlowWorkItem wi)
        throws ApplyException
    {
        Object value = null;
        try
        {
            value = ValueUtils.determineValue(this, wi);
        }
        catch (ValueException ve)
        {
            throw new ApplyException
                ("Failed to find value for decision", ve);
        }

        //getExpressionPool().setVariableInParent
        //    (this, ValueUtils.BOOLEAN_RESULT, new Boolean(value != null));
        ValueUtils.setBooleanResult(wi, (value != null));
        
        applyToParent(wi);
    }
    
}
