/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: EvalExpression.java 2257 2005-12-05 17:47:24Z jmettraux $
 */

//
// EvalExpression.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.expressions;

import openwfe.org.xml.XmlUtils;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.XmlAttribute;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.engine.workitem.AttributeUtils;
import openwfe.org.engine.expressions.raw.RawExpression;


/**
 * This expression evaluates the OpenWFE XML contained in a field or as the
 * text children of the expression itself.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: EvalExpression.java 2257 2005-12-05 17:47:24Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class EvalExpression

    //extends ZeroChildExpression
    extends CleanCompositeFlowExpression

    implements WithChildren

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(EvalExpression.class.getName());

    //
    // CONSTANTS & co

    /**
     * The attribute 'field' of the 'eval' expression indicates which field 
     * of the workitem contains the XML to evaluate.
     */
    public final static String A_FIELD
        = "field";

    //
    // FIELDS

    private boolean evalTriggered = false;

    //
    // CONSTRUCTORS

    //
    // BEAN METHODS

    /**
     * When this field is set to true, it means that the eval expression
     * finished the application of its children and triggered the evaluation
     * of the resulting XML.
     */
    public boolean getEvalTriggered ()
    {
        return this.evalTriggered;
    }

    public void setEvalTriggered (final boolean b)
    {
        this.evalTriggered = b;
    }

    //
    // METHODS from FlowExpression

    public void apply (final InFlowWorkItem wi)
        throws ApplyException
    {
        org.jdom.Content xml = null;

        try
        {
            final String fieldName = lookupAttribute(A_FIELD, wi);
            final String sXml = lookupAttribute(A_VALUE, wi);

            log.debug("apply() children : "+getChildren().size());

            if (fieldName != null)
            {
                xml = extractXmlFromField(wi, fieldName);
            }
            else if (getChildren().size() > 0)
            {
                final FlowExpressionId childId = 
                    (FlowExpressionId)getChildren().get(0);

                getExpressionPool().apply(childId, wi);
                return;
            }
            else //if (sXml != null && sXml.trim().length() > 0)
                //
                // XML to eval is [perhaps] text or CDATA child of the 
                // eval expression
            {
                xml = XmlUtils.extractXmlElement(sXml);
            }
        }
        catch (final Exception e)
        {
            throw new ApplyException
                ("failed to determine what to eval", e);
        }

        //log.debug("apply() xml is >"+XmlUtils.xmlToString(xml)+"<");

        // 
        // doing the eval

        try
        {
            eval(wi, xml);
        }
        catch (final Throwable t)
        {
            throw new ApplyException
                ("evaluation failure", t);
        }
    }

    public void reply (final InFlowWorkItem wi) 
        throws ReplyException
    {
        if (this.getEvalTriggered())
        {
            replyToParent(wi);
            return;
        }

        //
        // maybe one day, use the behalf system here as well
        //

        try
        {
            eval(wi, extractXmlFromField(wi, ValueUtils.F_RESULT));
        }
        catch (final Exception e)
        {
            throw new ReplyException
                ("Failed to eval XML result", e);
        }
    }

    //
    // METHODS

    /**
     * Triggers the evaluation of the XML fragment.
     */
    protected void eval (final InFlowWorkItem wi, final org.jdom.Content xml)
        throws Exception
    {
        //log.debug("eval() \n"+XmlUtils.xmlToString(xml));

        final RawExpression evalResult = getLauncher().eval(this, xml, wi);

        if (evalResult == null)
        {
            applyToParent(wi);
            return;
        }

        this.setEvalTriggered(true);
        this.storeItself();

        //
        // apply it

        evalResult.apply(wi);
    }

    private org.jdom.Content extractXmlFromField 
        (final InFlowWorkItem wi, final String fieldName)
    throws 
        Exception
    {
        final Attribute a = wi.getAttributes().get(fieldName);

        if (a != null)
        {
            if (a instanceof StringAttribute)
                return XmlUtils.extractXmlElement(a.toString());
            else if (a instanceof XmlAttribute)
                return ((XmlAttribute)a).getContent();
        }

        return null;
    }

    //
    // STATIC METHODS

}
