/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ExpressionWithTimeOut.java 2575 2006-05-08 11:52:39Z jmettraux $
 */

//
// ExpressionWithTimeOut.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.00 16.08.2003 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.expressions;

/**
 * This interface shall be implemented by every expression with a time out.
 * The purge daemon can determine if such expressions' timeOutReply() 
 * methods are to be called.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: ExpressionWithTimeOut.java 2575 2006-05-08 11:52:39Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public interface ExpressionWithTimeOut
{

    //
    // CONSTANTS & co

    /**
     * This constant is used to fetch the timeout values in
     * the expression's attribute or elsewhere.
     */
    public final static String TIMEOUT
        = "timeout";

    /**
     * This is the timeout variable '__timeout__'.
     */
    public final static String V_TIMEOUT
        = "__timeout__";

    /**
     * A history tag for keeping track of expressions / flows that
     * timed out.
     */
    public final static String EVT_TIMED_OUT
        = "+TOU";

    //
    // METHODS

    /**
     * This method should return false if the purge daemon should not
     * consider the implemented and instantiated Expression during its run.
     */
    public boolean isTimeOutActivated ();

    /**
     * by implementing this method, expressions define how their
     * timeout is determined.
     * For example, the priority of the timeout setting for a
     * Participant expression is :<br>
     * <ol>
     *   <li>expression</li>
     *   <li>participant</li>
     *   <li>expressionPool</li>
     * </ol>
     * So this behaviour is implemented in ParticipantExpression's 
     * determineTimeOut method.<br>
     * <br>
     * Returning a timeout of -1 means 'no timeout'.
     */
    public Long determineTimeOut ();

    /**
     * This method is called by the expression store purge daemon
     * on expressions that have timed out.
     */
    public void timeOutReply ()
        throws ReplyException;

}
