/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: FilterDefinitionExpression.java 2134 2005-09-27 11:44:15Z jmettraux $
 */

//
// FilterDefinitionExpression.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.expressions;

import openwfe.org.ApplicationContext;
import openwfe.org.misc.Text;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.raw.RawExpression;
import openwfe.org.engine.participants.Filter;
import openwfe.org.engine.participants.FilterEntry;


/**
 * The definition of a filter is now a work for this expression which
 * implements DefinitionExpression.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: FilterDefinitionExpression.java 2134 2005-09-27 11:44:15Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class FilterDefinitionExpression

    extends ZeroChildExpression

    implements DefinitionExpression

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(FilterDefinitionExpression.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    private org.jdom.Element xmlBranch = null;

    //
    // CONSTRUCTORS

    //
    // BEAN METHODS

    /**
     * A filter definition relies directly on parsing XML to determine
     * itself.
     * (A later implementation may see the XML constraint be moved to an
     * extension class).
     */
    public org.jdom.Element getXmlBranch ()
    {
        return this.xmlBranch;
    }

    public void setXmlBranch (final org.jdom.Element e)
    {
        this.xmlBranch = e;
    }

    //
    // METHODS from DefinitionExpression

    /**
     * Returns self, the method buildFilter(wi) then allows to build on the fly
     * the required Filter instance.
     */
    public Object eval (final InFlowWorkItem wi)
        throws ApplyException
    {
        //return buildFilter(this.xmlBranch, wi);

        getExpressionPool().removeExpression(this.getId());
        return this;
    }

    //
    // METHODS from FlowExpression

    public final void apply (InFlowWorkItem wi) 
        throws ApplyException
    {
        // never used
    }

    public final void reply (InFlowWorkItem wi) 
        throws ReplyException
    {
        // never used
    }

    public void init 
        (final ApplicationContext context,
         final FlowExpressionId environmentId, 
         final FlowExpressionId parentId, 
         final FlowExpressionId id, 
         final RawExpression generatingExpression,
         final Object raw,
         final InFlowWorkItem currentWi)
    throws 
        BuildException
    {
        super.init
            (context,
             environmentId,
             parentId,
             id,
             generatingExpression,
             raw,
             currentWi);

        //this.debugAttributes("init()");

        this.setXmlBranch((org.jdom.Element)raw);
    }

    //
    // METHODS

    /**
     * A dedicated lookupAttribute method, as filter definitions have a special
     * XML syntax.
     */
    protected String lookupAttribute
        (final org.jdom.Element elt,
         final String attributeName,
         final InFlowWorkItem wi)
    {
        final String value = elt.getAttributeValue(attributeName);

        if (value == null) return null;

        if (referencesNoVariable(value)) return value;

        log.debug("lookupAttribute() :: >"+value+"<");

        try
        {
            final VariableMap vMap = new VariableMap
                (getLauncher().fetchAttributes(this, elt), this, wi);

            return Text.substitute(value, vMap);
        }
        catch (final Exception e)
        {
            log.warn("lookupAttribute() problem while fetching attributes", e);
            return null;
        }
    }

    /**
     * Builds a filter out of an XML element.
     */
    protected Filter buildFilter 
        (/*final org.jdom.Element elt, */final InFlowWorkItem wi)
    {
        final Filter filter = new Filter();

        //
        // parse attributes

        filter.setName(lookupAttribute("name", wi));

        String sType = lookupAttribute("type", wi);
        if (sType == null)
        {
            filter.setType(Filter.TYPE_OPEN);
        }
        else
        {
            if ("open".equalsIgnoreCase(sType))
                filter.setType(Filter.TYPE_OPEN);
            else
                filter.setType(Filter.TYPE_CLOSED);
        }

        //final String sAdd = elt.getAttributeValue("add");
        final String sAdd = lookupAttribute("add", wi);
        if (sAdd == null)
        {
            filter.setAddAllowed(true);
        }
        else
        {
            filter.setAddAllowed("true".equalsIgnoreCase(sAdd));
        }

        //final String sRemove = elt.getAttributeValue("remove");
        final String sRemove = lookupAttribute("remove", wi);
        if (sRemove == null)
        {
            filter.setRemoveAllowed(false);
        }
        else
        {
            filter.setRemoveAllowed("true".equalsIgnoreCase(sRemove));
        }
        //log.debug("filter.removeAllowed is set to "+filter.isRemoveAllowed());

        //filter.setEntries(buildEntryList(elt, wi));
        filter.setEntries(buildEntryList(wi));

        //
        // return result
        
        return filter;
    }

    /**
     * Builds a filter entry list out of an XML element
     */
    protected java.util.List buildEntryList 
        (/*final org.jdom.Element elt, */final InFlowWorkItem wi)
    {
        final org.jdom.Element elt = this.xmlBranch;

        if (elt == null) return new java.util.ArrayList(0);

        final int size = elt.getChildren("field").size();
        final java.util.List result = new java.util.ArrayList(size);

        //log.debug
        //    ("buildEntryList() should return "+size+" entries");
        //log.debug
        //    ("buildEntryList() elt is \n"+
        //     openwfe.org.xml.XmlUtils.dumpContent(elt));

        final java.util.Iterator it = elt.getChildren("field").iterator();
        while (it.hasNext())
        {
            org.jdom.Element e = (org.jdom.Element)it.next();

            //String fieldRegex = e.getAttributeValue("regex");
            //String permissions = e.getAttributeValue("permissions");
            
            /*
            String fieldClassName = e.getAttributeValue("type");
            */

            final String fieldRegex = lookupAttribute(e, "regex", wi);
            final String permissions = lookupAttribute(e, "permissions", wi);

            final FilterEntry entry = new FilterEntry
                (fieldRegex, permissions/*, fieldClassName*/);

            result.add(entry);
        }

        //log.debug("buildEntryList() returning "+result.size()+" entries");
        
        return result;
    }

    //
    // STATIC METHODS

}
