/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: PrescientParticipantExpression.java 2436 2006-03-15 16:02:31Z jmettraux $
 */

//
// PrescientParticipantExpression.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.expressions;


import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.raw.RawExpression;


/**
 * A extension of ParticipantExpression that tries to give the name of the next
 * participant to its own participant. Of course, if it's not in a sequence, it
 * won't guess anything useful.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-03-15 17:02:31 +0100 (Wed, 15 Mar 2006) $
 * <br>$Id: PrescientParticipantExpression.java 2436 2006-03-15 16:02:31Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public class PrescientParticipantExpression

    extends ParticipantExpression

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(PrescientParticipantExpression.class.getName());
    */

    //
    // CONSTANTS

    /**
     * If possible, this expression will store the name of the next participant
     * in the field named 'next-participant'.
     */
    public final static String F_NEXT_PARTICIPANT
        = "next-participant";

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    /*
     * attempts to fetch the next participant expression from the current 
     * sequence
     */
    private ParticipantExpression fetchNext 
        (final FlowExpression feStart, final InFlowWorkItem wi)
    throws
        ApplyException
    {
        return null;
        /*
        if (this.getNext() == null) return null;

        FlowExpression feNext = getExpressionPool().fetch(feStart.getNext());

        if ((feNext instanceof RawExpression) &&
            (ParticipantExpression.class.isAssignableFrom
                (((RawExpression)feNext).getExpressionClass())))
        {
            RawExpression reNext = (RawExpression)feNext;

            return (ParticipantExpression)reNext.preApply(wi);
        }
        else if (feNext instanceof ParticipantExpression)
        {
            return (ParticipantExpression)feNext;
        }

        return fetchNext(feNext, wi);
        */
    }

    /**
     * Applies this expression, ie dispatches the workitem to the
     * participant according to the participant map 
     * (etc-engine/participants.xml)
     */
    public void apply (final InFlowWorkItem wi) 
        throws ApplyException
    {
        String nextParticipant = "";

        ParticipantExpression peNext = fetchNext(this, wi);

        if (peNext != null)
        {
            nextParticipant = peNext.getParticipantName(wi);

            if (nextParticipant == null) nextParticipant = "";
        }

        wi.getAttributes().puts(F_NEXT_PARTICIPANT, nextParticipant);

        super.apply(wi);
    }

    public void reply (final InFlowWorkItem wi)
        throws ReplyException
    {
        wi.getAttributes().remove(F_NEXT_PARTICIPANT);

        super.reply(wi);
    }

}
