/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: PrintExpression.java 2265 2005-12-09 07:02:26Z jmettraux $
 */

//
// PrintExpression.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.expressions;

import openwfe.org.engine.Definitions;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.StringAttribute;


/**
 * A kind of debugging expression : prints out a text to the stdout.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: PrintExpression.java 2265 2005-12-09 07:02:26Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class PrintExpression

    extends AbstractCompositeFlowExpression

    implements WithChildren

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(PrintExpression.class.getName());

    //
    // CONSTANTS & co

    /**
     * If the 'text' attribute is present, the text to print will be the
     * value of this attribute, else the text will be found as text child of
     * the 'print' tag.
     */
    public final static String A_TEXT
        = "text";

    //
    // FIELDS

    private int childIndex = -1;

    //
    // CONSTRUCTORS

    //
    // BEAN METHODS

    public int getChildIndex ()
    {
        return this.childIndex;
    }

    public void setChildIndex (final int i)
    {
        this.childIndex = i;
    }

    //
    // METHODS from FlowExpression

    public void apply (final InFlowWorkItem wi)
        throws ApplyException
    {
        //debugDump();

        //log.debug("apply()                "+getId());
        //log.debug("apply() environmentId  "+getEnvironmentId());

        if (this.getChildren().size() < 1)
        {
            String text = lookupAttribute(A_TEXT, wi);

            //log.debug("apply() text is >"+text+"<");

            if (text == null)
                text = lookupAttribute(A_VALUE, wi);
                //
                // that breaks etest_17 (not East17 though)

            //log.debug("apply() text is >"+text+"<");

            if (text != null)
            {
                //log.debug("apply() have to print >"+text+"<");

                if (text.trim().length() < 1) 
                    System.out.println();
                else
                    System.out.println(text);
            }

            applyToParent(wi);

            return;
        }

        this.childIndex = 0;

        applyNextChild(wi);
    }

    public synchronized void reply (final InFlowWorkItem wi) 
        throws ReplyException
    {
        //log.debug("reply() for "+this.getId());
        //log.debug("reply() wi.last is "+wi.getLastExpressionId());

        String s = wi.getAttributes().sget(ValueUtils.F_RESULT);

        if (s != null)
        {
            //log.debug("reply() s is >"+s+"<");

            if (s.startsWith("<?xml"))
            {
                int i = s.indexOf("\n");
                if (i > -1) s = s.substring(i+1);

                s = s.trim();

                //log.debug("reply() s is >"+s.replaceAll(" ", ".")+"<");
            }
        }

        //log.debug("reply() s is >"+s+"<");

        System.out.print(s);

        if (this.childIndex >= this.getChildren().size())
            //
            // over
        {
            //log.debug("reply() iteration is over.");

            System.out.println();

            replyToParent(wi);

            return;
        }

        //
        // not over

        try
        {
            applyNextChild(wi);
        }
        catch (final ApplyException e)
        {
            throw new ReplyException 
                ("Failed to apply next child", e);
        }
    }

    //
    // METHODS

    private void applyNextChild (final InFlowWorkItem wi)
        throws ApplyException
    {
        //log.debug("applyNextChild() childIndex : "+this.childIndex);

        final Object child = this.getChildren().get(this.childIndex);

        this.childIndex++;
        this.storeItself();

        if (child instanceof String)
        {
            final String s = substituteText((String)child, wi);

            //log.debug("applyNextChild() s is >"+s+"<");

            this.tag(wi);

            ValueUtils.setResult(wi, new StringAttribute(s));

            try
            {
                this.reply(wi);
            }
            catch (final ReplyException e)
            {
                throw new ApplyException("failed to go beyond next child", e);
            }

            return;
        }

        getExpressionPool().apply((FlowExpressionId)child, wi);
    }

    //
    // STATIC METHODS

}
