/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: RestoreExpression.java 2347 2006-02-24 15:43:24Z jmettraux $
 */

//
// RestoreExpression.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.expressions;

import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.engine.expressions.sync.MergeUtils;


/**
 * replaces the current workitem with a saved workitem (with the 'save'
 * expression)
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-02-24 16:43:24 +0100 (Fri, 24 Feb 2006) $
 * <br>$Id: RestoreExpression.java 2347 2006-02-24 15:43:24Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public class RestoreExpression

    extends ZeroChildExpression

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(RestoreExpression.class.getName());

    //
    // CONSTANTS

    /**
     * the 'from-variable' attribute is used to indicate from which
     * variable the workitem should be restored
     */
    public final static String A_FROM_VARIABLE 
        = "from-variable";

    /**
     * the 'merge-lead' attribute is optional, if it is set, it has to take the
     * value 'restored' or 'current'.
     */
    public final static String A_MERGE_LEAD
        = "merge-lead";

    private final static String V_RESTORED = "restored";
    private final static String V_CURRENT = "current";

    /**
     * When the attribute 'to-field' is present, the restored workitem's 
     * attributes will be inserted in the current workitem as a field.
     * The name of the field is of course, the value given to this 'to-field'
     * attribute.
     */
    public final static String A_TO_FIELD 
        = "to-field";
    
    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    private InFlowWorkItem fetchWorkitemToRestore (final String variableName)
    {
        try
        {
            return (InFlowWorkItem)lookupVariable(variableName);
        }
        catch (ClassCastException cce)
        {
            log.warn("apply() stuff to restore is not a workitem");
        }
        return null;
    }

    private InFlowWorkItem doMerge 
        (final InFlowWorkItem wi, final String variableName)
    {
        InFlowWorkItem newWorkitem = null;

        final String mergeLead = lookupAttribute(A_MERGE_LEAD, wi);

        final boolean theRestoredRules = V_RESTORED.equals(mergeLead);

        if (theRestoredRules)
            log.debug("apply() the restored workitem has priority in merge");
        else
            log.debug("apply() the current workitem has priority in merge");

        //
        // fetch workitem to restore

        final InFlowWorkItem restoredWorkitem = 
            fetchWorkitemToRestore(variableName);

        if (restoredWorkitem == null)
        {
            log.warn
                ("apply() no workitem in variable '"+variableName+
                 "'. Resuming.");

            return wi;
        }

        //
        // merge (or simply override)

        if (mergeLead == null)
            //
            // override
        {
            newWorkitem = restoredWorkitem;
        }
        else
            //
            // merge
        {
            if (theRestoredRules)
                newWorkitem = MergeUtils.merge(wi, restoredWorkitem);
            else
                newWorkitem = MergeUtils.merge(restoredWorkitem, wi);
        }

        return newWorkitem;
    }

    private InFlowWorkItem doInsert
        (final InFlowWorkItem wi, 
         final String variableName, 
         final String fieldName)
    {
        //
        // fetch workitem to restore

        final InFlowWorkItem restoredWorkitem = 
            fetchWorkitemToRestore(variableName);

        if (restoredWorkitem == null)
        {
            log.warn
                ("apply() no workitem in variable '"+variableName+
                 "'. Resuming.");

            return wi;
        }

        //
        // do insert
        
        wi.getAttributes().put
            (new StringAttribute(fieldName), 
             restoredWorkitem.getAttributes());

        return wi;
    }

    public void apply (final InFlowWorkItem wi)
        throws ApplyException
    {
        InFlowWorkItem newWorkitem = wi;

        final String variableName = lookupAttribute(A_FROM_VARIABLE, wi);

        if (variableName == null)
        {
            log.warn
                ("apply() no attribute '"+
                 A_FROM_VARIABLE+
                 "' for expression, cannot restore anything.");
        }
        else
        {
            final String toField = lookupAttribute(A_TO_FIELD, wi);

            if (toField != null)
                newWorkitem = doInsert(wi, variableName, toField);
            else
                newWorkitem = doMerge(wi, variableName);
        }

        applyToParent(wi);
    }
    
}
