/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: SequentialFlowExpression.java 2577 2006-05-08 12:56:25Z jmettraux $
 */

//
// SequentialFlowExpression.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.expressions;

import openwfe.org.engine.Definitions;
import openwfe.org.engine.expool.ExpressionPool;
import openwfe.org.engine.workitem.InFlowWorkItem;


/**
 * half-implementation of a sequential application of expressions
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-05-08 14:56:25 +0200 (Mon, 08 May 2006) $
 * <br>$Id: SequentialFlowExpression.java 2577 2006-05-08 12:56:25Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class SequentialFlowExpression

    extends CleanCompositeFlowExpression

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(SequentialFlowExpression.class.getName());

    //
    // FIELDS

    private FlowExpressionId currentId = null;

    //
    // CONSTRUCTORS

    //
    // BEAN METHODS

    /**
     * Returns the id of the current Expression :
     * current id contains the FlowExpressionId of the expression currently
     * applied (and whose reply is awaited) in the sequence.
     */
    public FlowExpressionId getCurrentId () { return this.currentId; }

    /**
     * Sets the id of the current Expression
     */
    public void setCurrentId (final FlowExpressionId fei) 
    { 
        this.currentId = fei; 
    }

    //
    // METHODS

    public void apply (final InFlowWorkItem wi) 
        throws ApplyException
    {
        //log.debug("apply()");

        if (getChildren() == null || getChildren().size() < 1)
        {
            applyToParent(wi);
            return;
        }

        FlowExpressionId next = null;

        if (this.currentId == null)
        {
            next = (FlowExpressionId)getChildren().get(0);
        }
        else
        {
            int current = getChildren().indexOf(this.currentId);

            //log.debug("apply() current index is "+current);

            if (current+1 >= getChildren().size())
            {
                this.currentId = null;

                log.debug("apply() current set to null and returning");

                return;
            }

            next = (FlowExpressionId)getChildren().get(current+1);
        }

        this.currentId = next;
        this.storeItself();

        //log.debug("apply() current is now "+this.currentId);

        try
        {
            getExpressionPool().apply(next, wi);
        }
        catch (final ApplyException ae)
        {
            log.warn
                ("apply() next expression failed .... "+next.toString(), ae);
            log.warn
                ("apply() applying next anyway");
            apply(wi);
        }
    }

}
