/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: SetValueExpression.java 2575 2006-05-08 11:52:39Z jmettraux $
 */

//
// SetValueExpression.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.expressions;

import openwfe.org.engine.workitem.InFlowWorkItem;


/**
 * Sets the value of a variable in the scope of the PARENT expression.
 *
 * This expression uses ValueUtils a lot.<br>
 * <br>
 * Since OpenWFE 1.5.1pre2, this expression implements DefinitionExpression
 * and can thus be found outside of the body of a flow.
 *
 * @see ValueUtils
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-05-08 13:52:39 +0200 (Mon, 08 May 2006) $
 * <br>$Id: SetValueExpression.java 2575 2006-05-08 11:52:39Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public class SetValueExpression

    extends OneChildExpression

    implements DefinitionExpression, WithChildren

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(SetValueExpression.class.getName());

    //
    // CONSTANTS
    
    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS from FlowExpression

    public void apply (final InFlowWorkItem wi)
        throws ApplyException
    {
        //this.debugDump();

        log.debug("apply()                "+getId());
        log.debug("apply() environmentId  "+getEnvironmentId());

        log.debug("apply() has child ? "+(getChildExpressionId() != null));

        if (getChildExpressionId() == null)
        {
            try
            {
                this.reply(wi);
            }
            catch (final ReplyException e)
            {
                throw new ApplyException
                    ("Failed to determine or set value", e);
            }
        }
        else
        {
            getExpressionPool().apply(getChildExpressionId(), wi);
        }
    }

    public void reply (final InFlowWorkItem wi)
        throws ReplyException
    {
        try
        {
            eval(wi);
        }
        catch (final ApplyException ae)
        {
            throw new ReplyException("Failed to determine/set value", ae);
        }

        replyToParent(wi);
    }

    //
    // METHODS

    public Object eval (final InFlowWorkItem wi)
        throws ApplyException
    {
        log.debug("eval()");

        Object value = null;

        if (getChildExpressionId() != null)
        {
            value = ValueUtils.getResult(wi);

            log.debug("eval() found value as child result");
        }
        
        if (value == null)
        {
            try
            {
                value = ValueUtils.determineValue(this, wi);
            }
            catch (final ValueException e)
            {
                log.debug("eval() problem", e);
                // value remains null
            }
        }

        log.debug("eval() value is >"+value+"<");

        try
        {
            ValueUtils.determineAndSetTarget
                ("", // 'field' or 'variable'
                 this,
                 wi,
                 value);
        }
        catch (final ValueException ve)
        {
            throw new ApplyException
                ("Failed to set value", ve);
        }

        return value;
    }

}
