/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: WhileExpression.java 2346 2006-02-24 15:01:22Z jmettraux $
 */

//
// WhileExpression.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.expressions;

import openwfe.org.engine.workitem.InFlowWorkItem;


/**
 * 'while' implementation (is extended by 'until')
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: WhileExpression.java 2346 2006-02-24 15:01:22Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class WhileExpression

    extends OneChildExpression

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(WhileExpression.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS from FlowExpression

    public void apply (final InFlowWorkItem wi) 
        throws ApplyException
    {
        //log.debug("apply()");

        if (getChildExpressionId() == null)
        {
            applyToParent(wi);
            return;
        }

        getExpressionPool().apply(getChildExpressionId(), wi);
    }

    /**
     * Simply replies to the parent expression and sets the
     * appropriate value for the '__cursor_command__' field.
     */
    public void reply (final InFlowWorkItem wi)
        throws ReplyException
    {
        if (shouldBreak(ValueUtils.lookupBooleanResult(wi)))
        {
            log.debug
                ("reply() '"+this.getId().getExpressionName()+
                 "' should break : true");

            wi.getAttributes().puts
                (CursorExpression.F_COMMAND, CursorExpression.C_BREAK);
        }

        this.replyToParent(wi);
    }

    //
    // METHODS

    /**
     * This small method is meant to be overriden by extending classes.
     * In this 'while' implementation, will return false if the passed
     * result is true and vice versa.
     */
    public boolean shouldBreak (final boolean booleanResult)
    {
        return ( ! booleanResult);
    }

    //
    // STATIC METHODS

}
