//
// AbstractExpressionState.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.expressions.state;

import openwfe.org.engine.expressions.FlowExpression;


/**
 * A base implementation for an ExpressionState
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: AbstractExpressionState.java 1882 2005-05-17 16:41:07Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class AbstractExpressionState

    implements ExpressionState

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(AbstractExpressionState.class.getName());
    */

    //
    // CONSTANTS & co

    //
    // FIELDS

    /**
     * This field is protected to allow children implementation access to
     * it directly. There is no 'getExpression' to avoid this field to be
     * persisted.
     */
    protected transient FlowExpression expression = null;

    private long since = -1;

    //
    // CONSTRUCTORS

    public AbstractExpressionState ()
    {
        super();

        this.since = System.currentTimeMillis();
    }

    //
    // BEAN METHODS

    public long getSince () { return this.since; }

    public void setSince (final long l) { this.since = l; }

    //
    // METHODS

    /**
     * Sets a reference to the flow expression in this state.
     */
    public void setExpression (final FlowExpression fe)
    {
        this.expression = fe;
    }

    //
    // STATIC METHODS

}
