/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: NormalState.java 2292 2006-01-21 12:54:29Z jmettraux $
 */

//
// NormalState.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.expressions.state;

import openwfe.org.engine.expool.ExpressionPool;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.ReplyException;


/**
 * The 'normal' state is the default state for any expression.
 * This class has a singleton which is used by the expression pool to
 * denote the NormalState for every expression. Thus there is one and only
 * one NormalState instance for any expression.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: NormalState.java 2292 2006-01-21 12:54:29Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class NormalState

    extends AbstractExpressionState

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(NormalState.class.getName());
    */

    //
    // CONSTANTS & co

    private final static String NAME = "normal";
    private final static char IDENTIFIER = '-';

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    //
    // METHODS from ExpressionState

    /**
     * Returns a one char identifier for the state (here '-')
     */
    public char getIdentifier ()
    {
        return IDENTIFIER;
    }

    /**
     * Will return 'normal'.
     */
    public String getName ()
    {
        return NAME;
    }

    public void apply (final InFlowWorkItem wi)
        throws ApplyException
    {
        this.expression.apply(wi);
    }

    public void reply (final InFlowWorkItem wi)
        throws ReplyException
    {
        this.expression.reply(wi);
    }

    public InFlowWorkItem cancel ()
        throws ApplyException
    {
        return this.expression.cancel();
    }

    /**
     * Makes this expression leave this state.
     */
    public void exitState ()
        throws ApplyException
    {
        if (this.expression.getState() != null)
        {
            throw new ApplyException
                ("Inconsistency : "+
                 "can't get out of normal state while another state '"+
                 this.expression.getState().getName()+"' is set");
        }
    }

    //
    // STATIC METHODS

}
